/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcInputFormat;
import com.facebook.hive.orc.OrcOutputFormat;
import com.facebook.hive.orc.OrcSerde;
import com.facebook.hive.orc.TestOrcFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestInputOutputFormat {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target/test/tmp"));
    @Rule
    public TestName testCaseName = new TestName();
    JobConf conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestInputOutputFormat." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInOutFormat() throws Exception {
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new MyRow(1, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(2, 2), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new MyRow(3, 2), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            properties.setProperty("columns", "x,y");
            properties.setProperty("columns.types", "int:int");
            serde.initialize((Configuration)this.conf, properties);
            Assert.assertEquals(OrcSerde.OrcSerdeRow.class, (Object)serde.getSerializedClass());
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<x:int,y:int>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.testFilePath));
            Assert.assertEquals((Object)true, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            fileList.add(this.fs.getFileStatus(this.workDir));
            Assert.assertEquals((Object)false, (Object)((InputFormatChecker)in).validateInput(this.fs, new HiveConf(), fileList));
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)1.0E-5);
            Assert.assertEquals((long)0L, (long)reader.getPos());
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)1.0E-5);
            reader.close();
            this.conf.set("hive.io.file.readcolumn.ids", "0");
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals(null, (Object)inspector.getStructFieldData((Object)value, (StructField)fields.get(1)));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            this.conf.set("hive.io.file.readcolumn.ids", "");
            reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            key = reader.createKey();
            value = (Writable)reader.createValue();
            rowNum = 0;
            fields = inspector.getAllStructFieldRefs();
            while (reader.next(key, (Object)value)) {
                Assert.assertEquals((long)(++rowNum), (long)intInspector.get(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
                Assert.assertEquals((long)2L, (long)intInspector.get(inspector.getStructFieldData(serde.deserialize(value), (StructField)fields.get(1))));
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMROutput() throws Exception {
        JobConf job = new JobConf((Configuration)this.conf);
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(NestedRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            RecordWriter writer = outFormat.getRecordWriter(this.fs, this.conf, this.testFilePath.toString(), (Progressable)Reporter.NULL);
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(1, 2, 3), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(4, 5, 6), (ObjectInspector)inspector));
            writer.write((Object)NullWritable.get(), (Object)serde.serialize((Object)new NestedRow(7, 8, 9), (ObjectInspector)inspector));
            writer.close(Reporter.NULL);
            serde = new OrcSerde();
            properties.setProperty("columns", "z,r");
            properties.setProperty("columns.types", "int:struct<x:int,y:int>");
            serde.initialize((Configuration)this.conf, properties);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            this.conf.set("hive.io.file.readcolumn.ids", "1");
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Object value = reader.createValue();
            int rowNum = 0;
            List fields = inspector.getAllStructFieldRefs();
            StructObjectInspector inner = (StructObjectInspector)((StructField)fields.get(1)).getFieldObjectInspector();
            List inFields = inner.getAllStructFieldRefs();
            IntObjectInspector intInspector = (IntObjectInspector)((StructField)inFields.get(0)).getFieldObjectInspector();
            while (reader.next(key, value)) {
                Assert.assertEquals(null, (Object)inspector.getStructFieldData(value, (StructField)fields.get(0)));
                Object sub = inspector.getStructFieldData(value, (StructField)fields.get(1));
                Assert.assertEquals((long)(3 * rowNum + 1), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(0))));
                Assert.assertEquals((long)(3 * rowNum + 2), (long)intInspector.get(inner.getStructFieldData(sub, (StructField)inFields.get(1))));
                ++rowNum;
            }
            Assert.assertEquals((long)3L, (long)rowNum);
            reader.close();
            return;
        }
    }

    @Test
    public void testEmptyFile() throws Exception {
        JobConf job = new JobConf((Configuration)this.conf);
        Properties properties = new Properties();
        OrcOutputFormat outFormat = new OrcOutputFormat();
        FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, MyRow.class, true, properties, (Progressable)Reporter.NULL);
        writer.close(true);
        properties.setProperty("columns", "x,y");
        properties.setProperty("columns.types", "int:int");
        OrcSerde serde = new OrcSerde();
        serde.initialize((Configuration)this.conf, properties);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        this.conf.set("hive.io.file.readcolumn.ids", "0,1");
        RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
        Object key = reader.createKey();
        Object value = reader.createValue();
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)1.0E-5);
        Assert.assertEquals((long)0L, (long)reader.getPos());
        Assert.assertEquals((Object)false, (Object)reader.next(key, value));
        reader.close();
        Assert.assertEquals(null, (Object)serde.getSerDeStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultTypes() throws Exception {
        JobConf job = new JobConf((Configuration)this.conf);
        Properties properties = new Properties();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            StructObjectInspector inspector = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(StringRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            OrcSerde serde = new OrcSerde();
            OrcOutputFormat outFormat = new OrcOutputFormat();
            FileSinkOperator.RecordWriter writer = outFormat.getHiveRecordWriter(this.conf, this.testFilePath, StringRow.class, true, properties, (Progressable)Reporter.NULL);
            writer.write(serde.serialize((Object)new StringRow("owen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("beth"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("laurel"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("hazen"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("colin"), (ObjectInspector)inspector));
            writer.write(serde.serialize((Object)new StringRow("miles"), (ObjectInspector)inspector));
            writer.close(true);
            serde = new OrcSerde();
            properties.setProperty("columns", "str,str2");
            serde.initialize((Configuration)this.conf, properties);
            inspector = (StructObjectInspector)serde.getObjectInspector();
            Assert.assertEquals((Object)"struct<str:string,str2:string>", (Object)inspector.getTypeName());
            OrcInputFormat in = new OrcInputFormat();
            FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
            InputSplit[] splits = in.getSplits(this.conf, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            RecordReader reader = in.getRecordReader(splits[0], this.conf, Reporter.NULL);
            Object key = reader.createKey();
            Writable value = (Writable)reader.createValue();
            List fields = inspector.getAllStructFieldRefs();
            StringObjectInspector strInspector = (StringObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"owen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"beth", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"laurel", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"hazen", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"colin", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)true, (Object)reader.next(key, (Object)value));
            Assert.assertEquals((Object)"miles", (Object)strInspector.getPrimitiveJavaObject(inspector.getStructFieldData((Object)value, (StructField)fields.get(0))));
            Assert.assertEquals((Object)false, (Object)reader.next(key, (Object)value));
            reader.close();
            return;
        }
    }

    static class StringRow
    implements Writable {
        String str;
        String str2;

        StringRow(String s) {
            this.str = s;
            this.str2 = s;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }
    }

    static class NestedRow
    implements Writable {
        int z;
        MyRow r;

        NestedRow(int x, int y, int z) {
            this.z = z;
            this.r = new MyRow(x, y);
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("unsupported");
        }
    }

    public static class MyRow
    implements Writable {
        int x;
        int y;

        MyRow(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("no write");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("no read");
        }
    }
}

