/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.DictionaryEncoder;
import com.facebook.hive.orc.IntDictionaryEncoder;
import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.TestBitFieldReader;
import com.facebook.hive.orc.TestDynamicArray;
import com.facebook.hive.orc.TestFileDump;
import com.facebook.hive.orc.TestInStream;
import com.facebook.hive.orc.TestInputOutputFormat;
import com.facebook.hive.orc.TestOrcFile;
import com.facebook.hive.orc.TestOrcStruct;
import com.facebook.hive.orc.TestSerializationUtils;
import com.facebook.hive.orc.TestStreamName;
import com.facebook.hive.orc.TestZlib;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Test;

public class TestIntDictionaryEncoder {
    private IntDictionaryEncoder buildDictionaryEncoder(int[] values, boolean sortKeys, boolean useVInts) {
        IntDictionaryEncoder dictEncoder = new IntDictionaryEncoder(sortKeys, 4, useVInts);
        for (int value : values) {
            dictEncoder.add((long)value);
        }
        return dictEncoder;
    }

    private void checkContent(IntDictionaryEncoder dictEncoder, int[] values, int[] order) throws Exception {
        dictEncoder.visit((DictionaryEncoder.Visitor)new TestVisitor(values, order));
    }

    @Test
    public void test1() throws Exception {
        IntDictionaryEncoder dictEncoder = new IntDictionaryEncoder(false, 4, true);
        Assert.assertEquals((long)98858L, (long)dictEncoder.getByteSize());
        Assert.assertEquals((int)0, (int)dictEncoder.size());
        int[] addKeys = new int[]{1, 1, 0, 3, 2, 1, 3, 0, -6, 100};
        int[] addKPos = new int[]{0, 0, 1, 2, 3, 0, 2, 1, 4, 5};
        int[] sizes = new int[]{1, 1, 2, 3, 4, 4, 4, 4, 5, 6};
        int[] expectedUniqueValues = new int[]{1, 0, 3, 2, -6, 100};
        int[] expectedOrder = new int[expectedUniqueValues.length];
        int ctr = 0;
        for (int v : expectedUniqueValues) {
            expectedOrder[ctr] = ctr;
            ++ctr;
        }
        ctr = 0;
        for (int i = 0; i < 10; ++i) {
            int pos = dictEncoder.add((long)addKeys[i]);
            Assert.assertEquals((int)addKPos[i], (int)pos);
            Assert.assertEquals((int)sizes[i], (int)dictEncoder.size());
        }
        this.checkContent(dictEncoder, expectedUniqueValues, expectedOrder);
        dictEncoder.clear();
        Assert.assertEquals((long)98858L, (long)dictEncoder.getByteSize());
        Assert.assertEquals((int)0, (int)dictEncoder.size());
        this.checkContent(dictEncoder, new int[0], new int[0]);
    }

    @Test
    public void test2() throws Exception {
        IntDictionaryEncoder[] encoders;
        for (IntDictionaryEncoder dictEncoder : encoders = new IntDictionaryEncoder[]{new IntDictionaryEncoder(4, true), new IntDictionaryEncoder(true, 4, true)}) {
            Assert.assertEquals((long)98858L, (long)dictEncoder.getByteSize());
            Assert.assertEquals((int)0, (int)dictEncoder.size());
            int[] addKeys = new int[]{1, 1, 0, 3, 2, 1, 3, 0, -6, 100};
            int[] addKPos = new int[]{0, 0, 1, 2, 3, 0, 2, 1, 4, 5};
            int[] sizes = new int[]{1, 1, 2, 3, 4, 4, 4, 4, 5, 6};
            int[] expectedOrderedUniqueValues = new int[]{-6, 0, 1, 2, 3, 100};
            int[] expectedOrder = new int[]{4, 1, 0, 3, 2, 5};
            for (int i = 0; i < 10; ++i) {
                int pos = dictEncoder.add((long)addKeys[i]);
                Assert.assertEquals((int)addKPos[i], (int)pos);
                Assert.assertEquals((int)sizes[i], (int)dictEncoder.size());
            }
            this.checkContent(dictEncoder, expectedOrderedUniqueValues, expectedOrder);
            dictEncoder.clear();
            Assert.assertEquals((long)98858L, (long)dictEncoder.getByteSize());
            Assert.assertEquals((int)0, (int)dictEncoder.size());
            this.checkContent(dictEncoder, new int[0], new int[0]);
        }
    }

    public static void main(String[] args) throws Exception {
        TestIntDictionaryEncoder test = new TestIntDictionaryEncoder();
        test.test1();
        test.test2();
        TestSerializationUtils serUtils = new TestSerializationUtils();
        serUtils.TestDoubles();
        TestDynamicArray dynamicArrayTest = new TestDynamicArray();
        dynamicArrayTest.testLongArray();
        TestZlib zlib = new TestZlib();
        zlib.testCorrupt();
        zlib.testNoOverflow();
        TestInStream inStreamTest = new TestInStream();
        inStreamTest.testUncompressed();
        inStreamTest.testCompressed();
        inStreamTest.testCorruptStream();
        TestBitFieldReader bit = new TestBitFieldReader();
        bit.testUncompressedSeek();
        bit.testCompressedSeek();
        bit.testSkips();
        TestOrcFile test1 = new TestOrcFile();
        test1.test1();
        test1.testEmptyFile();
        test1.testMetaData();
        test1.testUnionAndTimestamp();
        test1.testColumnProjection();
        test1.testSnappy();
        test1.testWithoutIndex();
        test1.testSeek();
        TestFileDump test2 = new TestFileDump();
        test2.testDump();
        test2.testDictionaryThreshold();
        test2.testUnsortedDictionary();
        TestStreamName test3 = new TestStreamName();
        test3.test1();
        TestInputOutputFormat test4 = new TestInputOutputFormat();
        test4.testInOutFormat();
        test4.testMROutput();
        test4.testEmptyFile();
        test4.testDefaultTypes();
        TestOrcStruct test5 = new TestOrcStruct();
        test5.testStruct();
        test5.testInspectorFromTypeInfo();
        test5.testUnion();
    }

    private static class TestVisitor
    implements DictionaryEncoder.Visitor<Long> {
        private final int[] values;
        private final int[] order;
        int currentIdx = 0;
        private final DataOutputBuffer buffer = new DataOutputBuffer();

        TestVisitor(int[] values, int[] order) {
            this.values = values;
            this.order = order;
        }

        public void visit(DictionaryEncoder.VisitorContext<Long> context) throws IOException {
            long curKey = (Long)context.getKey();
            Assert.assertEquals((String)("in value " + this.currentIdx), (long)this.values[this.currentIdx], (long)curKey);
            Assert.assertEquals((String)("in value " + this.currentIdx), (int)this.order[this.currentIdx], (int)context.getOriginalPosition());
            this.buffer.reset();
            context.writeBytes((OutputStream)this.buffer);
            ByteArrayInputStream inbuffer = new ByteArrayInputStream(this.buffer.getData());
            Assert.assertEquals((long)curKey, (long)SerializationUtils.readVslong((InputStream)inbuffer));
            ++this.currentIdx;
        }
    }
}

