/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.MemoryManager;
import com.facebook.hive.orc.OrcConf;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMemoryManager {
    private static final double ERROR = 1.0E-6;

    @Test
    public void testBasics() throws Exception {
        Configuration conf = new Configuration();
        MemoryManager mgr = new MemoryManager(conf);
        NullCallback callback = new NullCallback();
        long poolSize = mgr.getTotalMemoryPool();
        junit.framework.Assert.assertEquals((long)Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.5), (long)poolSize);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p1"), 1000L, (MemoryManager.Callback)callback, 1000L);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p1"), poolSize / 2L, (MemoryManager.Callback)callback, poolSize / 2L);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p2"), poolSize / 2L, (MemoryManager.Callback)callback, poolSize / 2L);
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p3"), poolSize / 2L, (MemoryManager.Callback)callback, poolSize / 2L);
        junit.framework.Assert.assertEquals((double)0.6666667, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.addWriter(new Path("p4"), poolSize / 2L, (MemoryManager.Callback)callback, poolSize / 2L);
        junit.framework.Assert.assertEquals((double)0.5, (double)mgr.getAllocationScale(), (double)1.0E-6);
        mgr.addWriter(new Path("p4"), 3L * poolSize / 2L, (MemoryManager.Callback)callback, poolSize / 2L);
        junit.framework.Assert.assertEquals((double)0.3333333, (double)mgr.getAllocationScale(), (double)1.0E-6);
        mgr.removeWriter(new Path("p1"));
        mgr.removeWriter(new Path("p2"));
        junit.framework.Assert.assertEquals((double)0.5, (double)mgr.getAllocationScale(), (double)1.0E-5);
        mgr.removeWriter(new Path("p4"));
        junit.framework.Assert.assertEquals((double)1.0, (double)mgr.getAllocationScale(), (double)1.0E-5);
    }

    @Test
    public void testConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hive.exec.orc.memory.pool", "0.9");
        MemoryManager mgr = new MemoryManager(conf);
        long mem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.err.print("Memory = " + mem);
        long pool = mgr.getTotalMemoryPool();
        Assert.assertTrue((String)("Pool too small: " + pool), ((double)mem * 0.899 < (double)pool ? 1 : 0) != 0);
        Assert.assertTrue((String)("Pool too big: " + pool), ((double)pool < (double)mem * 0.901 ? 1 : 0) != 0);
    }

    private static DoubleMatcher closeTo(double value, double error) {
        return new DoubleMatcher(value, error);
    }

    @Test
    public void testCallback() throws Exception {
        int i;
        Configuration conf = new Configuration();
        MemoryManager mgr = new MemoryManager(conf);
        long pool = mgr.getTotalMemoryPool();
        MemoryManager.Callback[] calls = new MemoryManager.Callback[20];
        for (i = 0; i < calls.length; ++i) {
            calls[i] = (MemoryManager.Callback)Mockito.mock(MemoryManager.Callback.class);
            mgr.addWriter(new Path(Integer.toString(i)), pool / 4L, calls[i], pool / 4L);
        }
        for (i = 0; i < 10000; ++i) {
            mgr.addedRow();
        }
        for (int call = 0; call < calls.length; ++call) {
            ((MemoryManager.Callback)Mockito.verify((Object)calls[call], (VerificationMode)Mockito.times((int)2))).checkMemory(Matchers.doubleThat((Matcher)TestMemoryManager.closeTo(0.2, 1.0E-6)));
        }
    }

    private void initializeLowMemoryModeTest(MemoryManagerForTest mgr, MemoryManager.Callback[] calls) throws Exception {
        int i;
        long pool = mgr.getTotalMemoryPool();
        for (i = 0; i < calls.length; ++i) {
            calls[i] = (MemoryManager.Callback)Mockito.mock(MemoryManager.Callback.class);
            Mockito.when((Object)calls[i].checkMemory(Matchers.anyDouble())).thenReturn((Object)(i % 2 == 0 ? 1 : 0));
            mgr.addWriter(new Path(Integer.toString(i)), pool / 4L, calls[i], pool / 4L - 1L);
        }
        for (i = 0; i < 5; ++i) {
            ((MemoryManager.Callback)Mockito.verify((Object)calls[i], (VerificationMode)Mockito.times((int)1))).enterLowMemoryMode();
        }
        for (i = 5; i < calls.length; ++i) {
            ((MemoryManager.Callback)Mockito.verify((Object)calls[i], (VerificationMode)Mockito.times((int)0))).enterLowMemoryMode();
        }
        for (i = 0; i < 10000; ++i) {
            mgr.addedRow();
        }
    }

    @Test
    public void testLowMemoryMode() throws Exception {
        Configuration conf = new Configuration();
        MemoryManagerForTest mgr = new MemoryManagerForTest(conf);
        MemoryManager.Callback[] calls = new MemoryManager.Callback[8];
        this.initializeLowMemoryModeTest(mgr, calls);
        for (int i = 0; i < calls.length; ++i) {
            if (i % 2 == 0) {
                junit.framework.Assert.assertEquals((String)"Popular writers not getting more memory", (Object)1.5, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
                continue;
            }
            junit.framework.Assert.assertEquals((String)"Unpopular writers hanging onto memory", (Object)0.5, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
        }
    }

    @Test
    public void testLowMemoryModeBidirectional() throws Exception {
        int i;
        Configuration conf = new Configuration();
        MemoryManagerForTest mgr = new MemoryManagerForTest(conf);
        MemoryManager.Callback[] calls = new MemoryManager.Callback[8];
        this.initializeLowMemoryModeTest(mgr, calls);
        for (i = 0; i < 5000; ++i) {
            mgr.addedRow();
        }
        for (i = 0; i < calls.length; ++i) {
            if (i % 2 == 0) {
                junit.framework.Assert.assertEquals((String)"Popular writers not getting more memory", (Object)1.75, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
                continue;
            }
            junit.framework.Assert.assertEquals((String)"Unpopular writers hanging onto memory", (Object)0.25, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
        }
        for (i = 0; i < calls.length; ++i) {
            Mockito.when((Object)calls[i].checkMemory(Matchers.anyDouble())).thenReturn((Object)(i % 2 != 0 ? 1 : 0));
        }
        for (i = 0; i < 5000; ++i) {
            mgr.addedRow();
        }
        for (i = 0; i < calls.length; ++i) {
            if (i % 2 == 0) {
                junit.framework.Assert.assertEquals((String)"Popular writers not getting more memory", (Object)1.75, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
                continue;
            }
            junit.framework.Assert.assertEquals((String)"Unpopular writers hanging onto memory", (Object)0.25, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
        }
        for (i = 0; i < 5000; ++i) {
            mgr.addedRow();
        }
        for (i = 0; i < calls.length; ++i) {
            if (i % 2 == 0) {
                junit.framework.Assert.assertEquals((String)"Popular writers not getting more memory", (Object)0.875, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
                continue;
            }
            junit.framework.Assert.assertEquals((String)"Unpopular writers hanging onto memory", (Object)1.125, (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
        }
    }

    @Test
    public void testLowMemoryModeMinRespected() throws Exception {
        int i;
        Configuration conf = new Configuration();
        MemoryManagerForTest mgr = new MemoryManagerForTest(conf);
        MemoryManager.Callback[] calls = new MemoryManager.Callback[8];
        this.initializeLowMemoryModeTest(mgr, calls);
        int n = 1;
        while ((double)(mgr.getTotalMemoryPool() / 4L) * mgr.getAllocationScale() * (0.875 / (double)(2 * n)) > (double)OrcConf.getLongVar((Configuration)conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_FILE_MIN_MEMORY_ALLOCATION)) {
            for (int i2 = 0; i2 < 5000; ++i2) {
                mgr.addedRow();
            }
            ++n;
        }
        double[] oldMultipliers = new double[calls.length];
        for (i = 0; i < calls.length; ++i) {
            oldMultipliers[i] = mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i)));
        }
        for (i = 0; i < 5000; ++i) {
            mgr.addedRow();
        }
        for (i = 0; i < calls.length; ++i) {
            junit.framework.Assert.assertEquals((String)"Minimum memory allocation not respected", (Object)oldMultipliers[i], (Object)mgr.getAllocationMultiplierForPath(new Path(Integer.toString(i))));
        }
    }

    private static class MemoryManagerForTest
    extends MemoryManager {
        public MemoryManagerForTest(Configuration conf) {
            super(conf);
        }

        public double getAllocationMultiplierForPath(Path path) {
            return ((MemoryManager.WriterInfo)this.writerList.get((Object)path)).allocationMultiplier;
        }
    }

    private static class DoubleMatcher
    extends BaseMatcher<Double> {
        final double expected;
        final double error;

        DoubleMatcher(double expected, double error) {
            this.expected = expected;
            this.error = error;
        }

        public boolean matches(Object val) {
            double dbl = (Double)val;
            return Math.abs(dbl - this.expected) <= this.error;
        }

        public void describeTo(Description description) {
            description.appendText("not sufficiently close to ");
            description.appendText(Double.toString(this.expected));
        }
    }

    private static class NullCallback
    implements MemoryManager.Callback {
        private NullCallback() {
        }

        public boolean checkMemory(double newScale) {
            return false;
        }

        public void enterLowMemoryMode() throws IOException {
        }
    }
}

