/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.BooleanColumnStatistics;
import com.facebook.hive.orc.ColumnStatistics;
import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.DoubleColumnStatistics;
import com.facebook.hive.orc.IntegerColumnStatistics;
import com.facebook.hive.orc.MemoryManager;
import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.OrcTestUtils;
import com.facebook.hive.orc.OrcUnion;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.RecordReader;
import com.facebook.hive.orc.StringColumnStatistics;
import com.facebook.hive.orc.StripeInformation;
import com.facebook.hive.orc.Writer;
import com.facebook.hive.orc.WriterImpl;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyBinary;
import com.facebook.hive.orc.lazy.OrcLazyBoolean;
import com.facebook.hive.orc.lazy.OrcLazyByte;
import com.facebook.hive.orc.lazy.OrcLazyDouble;
import com.facebook.hive.orc.lazy.OrcLazyFloat;
import com.facebook.hive.orc.lazy.OrcLazyInt;
import com.facebook.hive.orc.lazy.OrcLazyList;
import com.facebook.hive.orc.lazy.OrcLazyLong;
import com.facebook.hive.orc.lazy.OrcLazyMap;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import com.facebook.hive.orc.lazy.OrcLazyRow;
import com.facebook.hive.orc.lazy.OrcLazyShort;
import com.facebook.hive.orc.lazy.OrcLazyString;
import com.facebook.hive.orc.lazy.OrcLazyStruct;
import com.facebook.hive.orc.lazy.OrcLazyTimestamp;
import com.facebook.hive.orc.lazy.OrcLazyUnion;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestOrcFile {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    Path testFilePath2;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.testFilePath2 = new Path(this.workDir, "TestOrcFile2." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
        this.fs.delete(this.testFilePath2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHash() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            writer.addRow((Object)new OrcTestUtils.BigRow(false, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, OrcTestUtils.bytes(1), "1", new OrcTestUtils.MiddleStruct(OrcTestUtils.inner(1, "bye"), OrcTestUtils.inner(2, "sigh")), OrcTestUtils.list(OrcTestUtils.inner(3, "good"), OrcTestUtils.inner(4, "bad")), OrcTestUtils.map(OrcTestUtils.inner(3, "good"), OrcTestUtils.inner(4, "bad"))));
            writer.addRow((Object)new OrcTestUtils.BigRow(null, null, null, null, null, null, null, null, null, null, null, null));
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((int)1, (int)row.getFieldValue(0).hashCode());
            Assert.assertEquals((int)1, (int)row.getFieldValue(1).hashCode());
            Assert.assertEquals((int)1, (int)row.getFieldValue(2).hashCode());
            Assert.assertEquals((int)1, (int)row.getFieldValue(3).hashCode());
            Assert.assertEquals((int)1, (int)row.getFieldValue(4).hashCode());
            Assert.assertEquals((int)1065353216, (int)row.getFieldValue(5).hashCode());
            Assert.assertEquals((int)0x3FF00000, (int)row.getFieldValue(6).hashCode());
            Assert.assertEquals((int)32, (int)row.getFieldValue(7).hashCode());
            Assert.assertEquals((int)80, (int)row.getFieldValue(8).hashCode());
            Assert.assertEquals((int)8417130, (int)row.getFieldValue(9).hashCode());
            Assert.assertEquals((int)127296452, (int)row.getFieldValue(10).hashCode());
            Assert.assertEquals((int)7, (int)row.getFieldValue(11).hashCode());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((int)0, (int)row.getFieldValue(0).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(1).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(2).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(3).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(4).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(5).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(6).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(7).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(8).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(9).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(10).hashCode());
            Assert.assertEquals((int)0, (int)row.getFieldValue(11).hashCode());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeepCopy() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            writer.addRow((Object)new OrcTestUtils.BigRow(false, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, OrcTestUtils.bytes(1), "1", new OrcTestUtils.MiddleStruct(OrcTestUtils.inner(1, "bye"), OrcTestUtils.inner(2, "sigh")), OrcTestUtils.list(OrcTestUtils.inner(3, "good"), OrcTestUtils.inner(4, "bad")), OrcTestUtils.map(OrcTestUtils.inner(3, "good"), OrcTestUtils.inner(4, "bad"))));
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((boolean)false, (boolean)((BooleanWritable)((OrcLazyBoolean)row.getFieldValue(0)).materialize()).get());
            OrcLazyBoolean obj = new OrcLazyBoolean((OrcLazyBoolean)row.getFieldValue(0));
            Assert.assertEquals((boolean)false, (boolean)((BooleanWritable)obj.materialize()).get());
            Assert.assertEquals((int)1, (int)((ByteWritable)((OrcLazyByte)row.getFieldValue(1)).materialize()).get());
            obj = new OrcLazyByte((OrcLazyByte)row.getFieldValue(1));
            Assert.assertEquals((int)1, (int)((ByteWritable)obj.materialize()).get());
            Assert.assertEquals((int)1, (int)((ShortWritable)((OrcLazyShort)row.getFieldValue(2)).materialize()).get());
            obj = new OrcLazyShort((OrcLazyShort)row.getFieldValue(2));
            Assert.assertEquals((int)1, (int)((ShortWritable)obj.materialize()).get());
            Assert.assertEquals((int)1, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(3)).materialize()).get());
            obj = new OrcLazyInt((OrcLazyInt)row.getFieldValue(3));
            Assert.assertEquals((int)1, (int)((IntWritable)obj.materialize()).get());
            Assert.assertEquals((long)1L, (long)((LongWritable)((OrcLazyLong)row.getFieldValue(4)).materialize()).get());
            obj = new OrcLazyLong((OrcLazyLong)row.getFieldValue(4));
            Assert.assertEquals((long)1L, (long)((LongWritable)obj.materialize()).get());
            Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((FloatWritable)((OrcLazyFloat)row.getFieldValue(5)).materialize()).get()));
            obj = new OrcLazyFloat((OrcLazyFloat)row.getFieldValue(5));
            Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((FloatWritable)obj.materialize()).get()));
            Assert.assertEquals((Object)1.0, (Object)((DoubleWritable)((OrcLazyDouble)row.getFieldValue(6)).materialize()).get());
            obj = new OrcLazyDouble((OrcLazyDouble)row.getFieldValue(6));
            Assert.assertEquals((Object)1.0, (Object)((DoubleWritable)obj.materialize()).get());
            Assert.assertEquals((Object)OrcTestUtils.bytes(1), (Object)((OrcLazyBinary)row.getFieldValue(7)).materialize());
            obj = new OrcLazyBinary((OrcLazyBinary)row.getFieldValue(7));
            Assert.assertEquals((Object)OrcTestUtils.bytes(1), (Object)obj.materialize());
            Assert.assertEquals((String)"1", (String)((Text)((OrcLazyString)row.getFieldValue(8)).materialize()).toString());
            obj = new OrcLazyString((OrcLazyString)row.getFieldValue(8));
            Assert.assertEquals((String)"1", (String)((Text)obj.materialize()).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekAcrossChunks() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.DoubleRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)0x200000L, (CompressionKind)CompressionKind.ZLIB, (int)262144, (int)10000);
            Random rand = new Random(42L);
            double[] values = new double[131702];
            for (i2 = 0; i2 < 32768; ++i2) {
                values[i2] = 0.0;
                writer.addRow((Object)new OrcTestUtils.DoubleRow(values[i2]));
            }
            for (i2 = 0; i2 < 32768; ++i2) {
                values[i2 + 32768] = rand.nextDouble();
                writer.addRow((Object)new OrcTestUtils.DoubleRow(values[i2 + 32768]));
            }
            for (i2 = 0; i2 < 32768; ++i2) {
                values[i2 + 32768 + 32768] = 0.0;
                writer.addRow((Object)new OrcTestUtils.DoubleRow(values[i2 + 32768 + 32768]));
            }
            for (i2 = 0; i2 < 32768; ++i2) {
                values[i2 + 32768 + 32768 + 32768] = rand.nextDouble();
                writer.addRow((Object)new OrcTestUtils.DoubleRow(values[i2 + 32768 + 32768 + 32768]));
            }
            writer.close();
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_READ_COMPRESSION_STRIDES, (int)2);
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_EAGER_HDFS_READ, (boolean)false);
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            List fields = readerInspector.getAllStructFieldRefs();
            DoubleObjectInspector columnInspector = (DoubleObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector();
            RecordReader rows = reader.rows(null);
            Object row = null;
            for (i = 0; i < 40001; ++i) {
                row = rows.next(row);
            }
            Assert.assertEquals((Object)values[40000], (Object)columnInspector.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            for (i = 0; i < 80000; ++i) {
                rows.next(row);
            }
            Assert.assertEquals((Object)values[120000], (Object)columnInspector.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            writer.addRow((Object)new OrcTestUtils.BigRow(false, (byte)1, (short)1024, 65536, Long.MAX_VALUE, Float.valueOf(1.0f), -15.0, OrcTestUtils.bytes(0, 1, 2, 3, 4), "hi", new OrcTestUtils.MiddleStruct(OrcTestUtils.inner(1, "bye"), OrcTestUtils.inner(2, "sigh")), OrcTestUtils.list(OrcTestUtils.inner(3, "good"), OrcTestUtils.inner(4, "bad")), OrcTestUtils.map(new OrcTestUtils.InnerStruct[0])));
            writer.addRow((Object)new OrcTestUtils.BigRow(true, (byte)100, (short)2048, 65536, Long.MAX_VALUE, Float.valueOf(2.0f), -5.0, OrcTestUtils.bytes(new int[0]), "bye", new OrcTestUtils.MiddleStruct(OrcTestUtils.inner(1, "bye"), OrcTestUtils.inner(2, "sigh")), OrcTestUtils.list(OrcTestUtils.inner(100000000, "cat"), OrcTestUtils.inner(-100000, "in"), OrcTestUtils.inner(1234, "hat")), OrcTestUtils.map(OrcTestUtils.inner(5, "chani"), OrcTestUtils.inner(1, "mauddib"))));
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((long)2L, (long)stats[1].getNumberOfValues());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
            Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
            Assert.assertEquals((String)"count: 2 true: 1", (String)stats[1].toString());
            Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
            Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
            Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
            Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)stats[3]).getSum());
            Assert.assertEquals((String)"count: 2 min: 1024 max: 2048 sum: 3072", (String)stats[3].toString());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
            Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
            Assert.assertEquals((String)"count: 2 min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
            Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
            Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
            Assert.assertEquals((double)-20.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
            Assert.assertEquals((String)"count: 2 min: -15.0 max: -5.0 sum: -20.0", (String)stats[7].toString());
            Assert.assertEquals((String)"count: 2 min: bye max: hi", (String)stats[9].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            Assert.assertEquals((String)"struct<boolean1:boolean,byte1:tinyint,short1:smallint,int1:int,long1:bigint,float1:float,double1:double,bytes1:binary,string1:string,middle:struct<list:array<struct<int1:int,string1:string>>>,list:array<struct<int1:int,string1:string>>,map:map<string,struct<int1:int,string1:string>>>", (String)readerInspector.getTypeName());
            List fields = readerInspector.getAllStructFieldRefs();
            BooleanObjectInspector bo = (BooleanObjectInspector)readerInspector.getStructFieldRef("boolean1").getFieldObjectInspector();
            ByteObjectInspector by = (ByteObjectInspector)readerInspector.getStructFieldRef("byte1").getFieldObjectInspector();
            ShortObjectInspector sh = (ShortObjectInspector)readerInspector.getStructFieldRef("short1").getFieldObjectInspector();
            IntObjectInspector in = (IntObjectInspector)readerInspector.getStructFieldRef("int1").getFieldObjectInspector();
            LongObjectInspector lo = (LongObjectInspector)readerInspector.getStructFieldRef("long1").getFieldObjectInspector();
            FloatObjectInspector fl = (FloatObjectInspector)readerInspector.getStructFieldRef("float1").getFieldObjectInspector();
            DoubleObjectInspector dbl = (DoubleObjectInspector)readerInspector.getStructFieldRef("double1").getFieldObjectInspector();
            BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
            StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
            StructObjectInspector mid = (StructObjectInspector)readerInspector.getStructFieldRef("middle").getFieldObjectInspector();
            List midFields = mid.getAllStructFieldRefs();
            ListObjectInspector midli = (ListObjectInspector)((StructField)midFields.get(0)).getFieldObjectInspector();
            StructObjectInspector inner = (StructObjectInspector)midli.getListElementObjectInspector();
            List inFields = inner.getAllStructFieldRefs();
            IntObjectInspector inner_in = (IntObjectInspector)((StructField)inFields.get(0)).getFieldObjectInspector();
            StringObjectInspector inner_st = (StringObjectInspector)((StructField)inFields.get(1)).getFieldObjectInspector();
            ListObjectInspector li = (ListObjectInspector)readerInspector.getStructFieldRef("list").getFieldObjectInspector();
            MapObjectInspector ma = (MapObjectInspector)readerInspector.getStructFieldRef("map").getFieldObjectInspector();
            StructObjectInspector lc = (StructObjectInspector)li.getListElementObjectInspector();
            StringObjectInspector mk = (StringObjectInspector)ma.getMapKeyObjectInspector();
            StructObjectInspector mv = (StructObjectInspector)ma.getMapValueObjectInspector();
            RecordReader rows = reader.rows(null);
            Object row = rows.next(null);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((boolean)false, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertEquals((int)1, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((int)1024, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
            Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
            Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
            Assert.assertEquals((double)1.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
            Assert.assertEquals((double)-15.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
            Assert.assertEquals((Object)OrcTestUtils.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
            Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
            List midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
            Assert.assertNotNull((Object)midRow);
            Assert.assertEquals((int)2, (int)midRow.size());
            Assert.assertEquals((int)1, (int)inner_in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"bye", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
            Assert.assertEquals((int)2, (int)inner_in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"sigh", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
            List list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
            Assert.assertEquals((int)2, (int)list.size());
            Assert.assertEquals((int)3, (int)inner_in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"good", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
            Assert.assertEquals((int)4, (int)inner_in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"bad", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
            Map map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
            Assert.assertEquals((int)0, (int)map.size());
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            Assert.assertEquals((boolean)true, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            Assert.assertEquals((int)100, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            Assert.assertEquals((int)2048, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
            Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
            Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
            Assert.assertEquals((double)2.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
            Assert.assertEquals((double)-5.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
            Assert.assertEquals((Object)OrcTestUtils.bytes(new int[0]), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
            Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
            midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
            Assert.assertNotNull((Object)midRow);
            Assert.assertEquals((int)2, (int)midRow.size());
            Assert.assertEquals((int)1, (int)inner_in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"bye", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
            Assert.assertEquals((int)2, (int)inner_in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"sigh", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
            list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
            Assert.assertEquals((int)3, (int)list.size());
            Assert.assertEquals((int)100000000, (int)inner_in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"cat", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
            Assert.assertEquals((int)-100000, (int)inner_in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"in", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
            Assert.assertEquals((int)1234, (int)inner_in.get(inner.getStructFieldData(list.get(2), (StructField)inFields.get(0))));
            Assert.assertEquals((String)"hat", (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(2), (StructField)inFields.get(1))));
            map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
            Assert.assertEquals((int)2, (int)map.size());
            boolean[] found = new boolean[2];
            for (Object key : map.keySet()) {
                String str = mk.getPrimitiveJavaObject(key);
                if (str.equals("chani")) {
                    Assert.assertEquals((boolean)false, (boolean)found[0]);
                    Assert.assertEquals((int)5, (int)inner_in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                    Assert.assertEquals((String)str, (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                    found[0] = true;
                    continue;
                }
                if (str.equals("mauddib")) {
                    Assert.assertEquals((boolean)false, (boolean)found[1]);
                    Assert.assertEquals((int)1, (int)inner_in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                    Assert.assertEquals((String)str, (String)inner_st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                    found[1] = true;
                    continue;
                }
                throw new IllegalArgumentException("Unknown key " + str);
            }
            Assert.assertEquals((boolean)true, (boolean)found[0]);
            Assert.assertEquals((boolean)true, (boolean)found[1]);
            Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnProjection() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000L, (CompressionKind)CompressionKind.NONE, (int)100, (int)1000);
            Random r1 = new Random(1L);
            Random r2 = new Random(2L);
            int minInt = 0;
            int maxInt = 0;
            String minStr = null;
            String maxStr = null;
            for (int i = 0; i < 21000; ++i) {
                int x = r1.nextInt();
                String y = Long.toHexString(r2.nextLong());
                if (i == 0 || x < minInt) {
                    minInt = x;
                }
                if (i == 0 || x > maxInt) {
                    maxInt = x;
                }
                if (i == 0 || y.compareTo(minStr) < 0) {
                    minStr = y;
                }
                if (i == 0 || y.compareTo(maxStr) > 0) {
                    maxStr = y;
                }
                writer.addRow((Object)OrcTestUtils.inner(x, y));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            ColumnStatistics[] stats = reader.getStatistics();
            Assert.assertEquals((int)3, (int)stats.length);
            for (ColumnStatistics s : stats) {
                Assert.assertEquals((long)21000L, (long)s.getNumberOfValues());
                if (s instanceof IntegerColumnStatistics) {
                    Assert.assertEquals((long)minInt, (long)((IntegerColumnStatistics)s).getMinimum());
                    Assert.assertEquals((long)maxInt, (long)((IntegerColumnStatistics)s).getMaximum());
                    continue;
                }
                if (!(s instanceof StringColumnStatistics)) continue;
                Assert.assertEquals((String)maxStr, (String)((StringColumnStatistics)s).getMaximum());
                Assert.assertEquals((String)minStr, (String)((StringColumnStatistics)s).getMinimum());
            }
            List types = reader.getTypes();
            Assert.assertEquals((int)3, (int)types.size());
            Assert.assertEquals((Object)OrcProto.Type.Kind.STRUCT, (Object)((OrcProto.Type)types.get(0)).getKind());
            Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypesCount());
            Assert.assertEquals((int)1, (int)((OrcProto.Type)types.get(0)).getSubtypes(0));
            Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypes(1));
            Assert.assertEquals((Object)OrcProto.Type.Kind.INT, (Object)((OrcProto.Type)types.get(1)).getKind());
            Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(1)).getSubtypesCount());
            Assert.assertEquals((Object)OrcProto.Type.Kind.STRING, (Object)((OrcProto.Type)types.get(2)).getKind());
            Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(2)).getSubtypesCount());
            RecordReader rows1 = reader.rows(new boolean[]{true, true, false});
            RecordReader rows2 = reader.rows(new boolean[]{true, false, true});
            r1 = new Random(1L);
            r2 = new Random(2L);
            OrcLazyStruct row1 = null;
            OrcLazyStruct row2 = null;
            for (int i = 0; i < 21000; ++i) {
                Assert.assertEquals((boolean)true, (boolean)rows1.hasNext());
                Assert.assertEquals((boolean)true, (boolean)rows2.hasNext());
                row1 = (OrcLazyStruct)rows1.next(row1);
                row2 = (OrcLazyStruct)rows2.next(row2);
                Assert.assertEquals((int)r1.nextInt(), (int)((IntWritable)((OrcLazyInt)((OrcStruct)row1.materialize()).getFieldValue(0)).materialize()).get());
                Assert.assertEquals((String)Long.toHexString(r2.nextLong()), (String)((OrcLazyString)((OrcStruct)row2.materialize()).getFieldValue(1)).materialize().toString());
            }
            Assert.assertEquals((boolean)false, (boolean)rows1.hasNext());
            Assert.assertEquals((boolean)false, (boolean)rows2.hasNext());
            rows1.close();
            rows2.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyFile() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000L, (CompressionKind)CompressionKind.NONE, (int)100, (int)10000);
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            Assert.assertEquals((boolean)false, (boolean)reader.rows(null).hasNext());
            Assert.assertEquals((Object)CompressionKind.NONE, (Object)reader.getCompression());
            Assert.assertEquals((long)0L, (long)reader.getNumberOfRows());
            Assert.assertEquals((int)0, (int)reader.getCompressionSize());
            Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
            Assert.assertEquals((long)3L, (long)reader.getContentLength());
            Assert.assertEquals((boolean)false, (boolean)reader.getStripes().iterator().hasNext());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaData() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000L, (CompressionKind)CompressionKind.NONE, (int)100, (int)10000);
            writer.addUserMetadata("my.meta", OrcTestUtils.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128));
            writer.addUserMetadata("clobber", OrcTestUtils.byteBuf(1, 2, 3));
            writer.addUserMetadata("clobber", OrcTestUtils.byteBuf(4, 3, 2, 1));
            ByteBuffer bigBuf = ByteBuffer.allocate(40000);
            Random random = new Random(0L);
            random.nextBytes(bigBuf.array());
            writer.addUserMetadata("big", bigBuf);
            bigBuf.position(0);
            writer.addRow((Object)new OrcTestUtils.BigRow(true, (byte)127, (short)1024, 42, 0xA80000000L, Float.valueOf(3.1415f), -2.713, null, null, null, null, null));
            writer.addUserMetadata("clobber", OrcTestUtils.byteBuf(5, 7, 11, 13, 17, 19));
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            Assert.assertEquals((Object)OrcTestUtils.byteBuf(5, 7, 11, 13, 17, 19), (Object)reader.getMetadataValue("clobber"));
            Assert.assertEquals((Object)OrcTestUtils.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128), (Object)reader.getMetadataValue("my.meta"));
            Assert.assertEquals((Object)bigBuf, (Object)reader.getMetadataValue("big"));
            try {
                reader.getMetadataValue("unknown");
                Assert.assertTrue((boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int i = 0;
            for (String key : reader.getMetadataKeys()) {
                if ("my.meta".equals(key) || "clobber".equals(key) || "big".equals(key)) {
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("unknown key " + key);
            }
            Assert.assertEquals((int)3, (int)i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnionAndTimestamp() throws Exception {
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addFieldNames("time").addFieldNames("union").addSubtypes(1).addSubtypes(2).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.TIMESTAMP).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.UNION).addSubtypes(3).addSubtypes(4).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING).build());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = OrcLazyObjectInspectorUtils.createWritableObjectInspector((int)0, types);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000L, (CompressionKind)CompressionKind.NONE, (int)100, (int)10000);
            OrcStruct row = new OrcStruct(((OrcProto.Type)types.get(0)).getFieldNamesList());
            OrcUnion union = new OrcUnion();
            row.setFieldValue(1, (Object)union);
            row.setFieldValue(0, (Object)Timestamp.valueOf("2000-03-12 15:00:00"));
            union.set((byte)0, (Object)new IntWritable(42));
            writer.addRow((Object)row);
            row.setFieldValue(0, (Object)Timestamp.valueOf("2000-03-20 12:00:00.123456789"));
            union.set((byte)1, (Object)new Text("hello"));
            writer.addRow((Object)row);
            row.setFieldValue(0, null);
            row.setFieldValue(1, null);
            writer.addRow((Object)row);
            row.setFieldValue(1, (Object)union);
            union.set((byte)0, null);
            writer.addRow((Object)row);
            union.set((byte)1, null);
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(200000));
            row.setFieldValue(0, (Object)Timestamp.valueOf("1900-01-01 00:00:00"));
            writer.addRow((Object)row);
            for (i2 = 1900; i2 < 2200; ++i2) {
                row.setFieldValue(0, (Object)Timestamp.valueOf(i2 + "-05-05 12:34:56." + i2));
                if ((i2 & 1) == 0) {
                    union.set((byte)0, (Object)new IntWritable(i2 * i2));
                } else {
                    union.set((byte)1, (Object)new Text(new Integer(i2 * i2).toString()));
                }
                writer.addRow((Object)row);
            }
            row.setFieldValue(0, null);
            union.set((byte)0, (Object)new IntWritable(1732050807));
            for (i2 = 0; i2 < 5000; ++i2) {
                writer.addRow((Object)row);
            }
            union.set((byte)0, (Object)new IntWritable(0));
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(10));
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(138));
            writer.addRow((Object)row);
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
            Assert.assertEquals((long)5309L, (long)reader.getNumberOfRows());
            int stripeCount = 0;
            int rowCount = 0;
            long currentOffset = -1L;
            for (StripeInformation stripe : reader.getStripes()) {
                ++stripeCount;
                rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
                if (currentOffset < 0L) {
                    currentOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
                    continue;
                }
                Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
                currentOffset += stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
            }
            Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
            Assert.assertEquals((int)2, (int)stripeCount);
            Assert.assertEquals((long)reader.getContentLength(), (long)currentOffset);
            RecordReader rows = reader.rows(null);
            Assert.assertEquals((long)0L, (long)rows.getRowNumber());
            Assert.assertEquals((double)0.0, (double)rows.getProgress(), (double)1.0E-6);
            Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            OrcLazyStruct lazyRow = (OrcLazyStruct)rows.next(null);
            row = (OrcStruct)lazyRow.materialize();
            inspector = reader.getObjectInspector();
            Assert.assertEquals((String)"struct<time:timestamp,union:uniontype<int,string>>", (String)inspector.getTypeName());
            Assert.assertEquals((Object)Timestamp.valueOf("2000-03-12 15:00:00"), (Object)((TimestampWritable)((OrcLazyTimestamp)row.getFieldValue(0)).materialize()).getTimestamp());
            union = (OrcUnion)((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((int)0, (int)union.getTag());
            Assert.assertEquals((Object)new IntWritable(42), (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((Object)Timestamp.valueOf("2000-03-20 12:00:00.123456789"), (Object)((TimestampWritable)((OrcLazyTimestamp)row.getFieldValue(0)).materialize()).getTimestamp());
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((int)1, (int)union.getTag());
            Assert.assertEquals((Object)new Text("hello"), (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals(null, (Object)((OrcLazyObject)row.getFieldValue(0)).materialize());
            Assert.assertEquals(null, (Object)((OrcLazyObject)row.getFieldValue(1)).materialize());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals(null, (Object)((OrcLazyObject)row.getFieldValue(0)).materialize());
            union = (OrcUnion)((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((int)0, (int)union.getTag());
            Assert.assertEquals(null, (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals(null, (Object)((OrcLazyObject)row.getFieldValue(0)).materialize());
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((int)1, (int)union.getTag());
            Assert.assertEquals(null, (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((Object)Timestamp.valueOf("1900-01-01 00:00:00"), (Object)((TimestampWritable)((OrcLazyTimestamp)row.getFieldValue(0)).materialize()).getTimestamp());
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((Object)new IntWritable(200000), (Object)union.getObject());
            for (i = 1900; i < 2200; ++i) {
                lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
                row = (OrcStruct)lazyRow.materialize();
                Assert.assertEquals((Object)Timestamp.valueOf(i + "-05-05 12:34:56." + i), (Object)((TimestampWritable)((OrcLazyTimestamp)row.getFieldValue(0)).materialize()).getTimestamp());
                ((OrcLazyUnion)row.getFieldValue(1)).materialize();
                if ((i & 1) == 0) {
                    Assert.assertEquals((int)0, (int)union.getTag());
                    Assert.assertEquals((Object)new IntWritable(i * i), (Object)union.getObject());
                    continue;
                }
                Assert.assertEquals((int)1, (int)union.getTag());
                Assert.assertEquals((Object)new Text(new Integer(i * i).toString()), (Object)union.getObject());
            }
            for (i = 0; i < 5000; ++i) {
                lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
                row = (OrcStruct)lazyRow.materialize();
                ((OrcLazyUnion)row.getFieldValue(1)).materialize();
                Assert.assertEquals((Object)new IntWritable(1732050807), (Object)union.getObject());
            }
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((Object)new IntWritable(0), (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((Object)new IntWritable(10), (Object)union.getObject());
            lazyRow = (OrcLazyStruct)rows.next((Object)lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            ((OrcLazyUnion)row.getFieldValue(1)).materialize();
            Assert.assertEquals((Object)new IntWritable(138), (Object)union.getObject());
            Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            Assert.assertEquals((double)1.0, (double)rows.getProgress(), (double)1.0E-5);
            Assert.assertEquals((long)reader.getNumberOfRows(), (long)rows.getRowNumber());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnappy() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000L, (CompressionKind)CompressionKind.SNAPPY, (int)100, (int)10000);
            Random rand = new Random(12L);
            for (int i = 0; i < 10000; ++i) {
                writer.addRow((Object)new OrcTestUtils.InnerStruct(rand.nextInt(), Integer.toHexString(rand.nextInt())));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            rand = new Random(12L);
            OrcLazyStruct row = null;
            for (int i = 0; i < 10000; ++i) {
                Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
                row = (OrcLazyStruct)rows.next(row);
                Assert.assertEquals((int)rand.nextInt(), (int)((IntWritable)((OrcLazyInt)((OrcStruct)row.materialize()).getFieldValue(0)).materialize()).get());
                Assert.assertEquals((String)Integer.toHexString(rand.nextInt()), (String)((OrcLazyString)((OrcStruct)row.materialize()).getFieldValue(1)).materialize().toString());
            }
            Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithoutIndex() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)5000L, (CompressionKind)CompressionKind.SNAPPY, (int)1000, (int)0);
            Random rand = new Random(24L);
            for (int i = 0; i < 10000; ++i) {
                OrcTestUtils.InnerStruct row = new OrcTestUtils.InnerStruct(rand.nextInt(), Integer.toBinaryString(rand.nextInt()));
                for (int j = 0; j < 5; ++j) {
                    writer.addRow((Object)row);
                }
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            Assert.assertEquals((long)50000L, (long)reader.getNumberOfRows());
            Assert.assertEquals((int)0, (int)reader.getRowIndexStride());
            StripeInformation stripe = (StripeInformation)reader.getStripes().iterator().next();
            Assert.assertEquals((boolean)true, (stripe.getDataLength() != 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)stripe.getIndexLength());
            RecordReader rows = reader.rows(null);
            rand = new Random(24L);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            for (int i = 0; i < 10000; ++i) {
                int intVal = rand.nextInt();
                String strVal = Integer.toBinaryString(rand.nextInt());
                for (int j = 0; j < 5; ++j) {
                    Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
                    lazyRow = (OrcLazyStruct)rows.next(lazyRow);
                    row = (OrcStruct)lazyRow.materialize();
                    Assert.assertEquals((int)intVal, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
                    Assert.assertEquals((String)strVal, (String)((OrcLazyString)row.getFieldValue(1)).materialize().toString());
                }
            }
            Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomRowInputs writeRandomRows(int count, boolean lowMemoryMode) throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.ReallyBigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_FILE_ENABLE_LOW_MEMORY_MODE, (boolean)lowMemoryMode);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 8000000L, CompressionKind.ZLIB, 65536, 1000, new MemoryManager(this.conf));
            Random rand = new Random(42L);
            RandomRowInputs inputs = new RandomRowInputs(count);
            long[] intValues = inputs.intValues;
            double[] doubleValues = inputs.doubleValues;
            String[] stringValues = inputs.stringValues;
            BytesWritable[] byteValues = inputs.byteValues;
            String[] words = inputs.words;
            for (i = 0; i < words.length; ++i) {
                words[i] = Integer.toHexString(rand.nextInt());
            }
            for (i = 0; i < count / 2; ++i) {
                intValues[2 * i] = rand.nextLong();
                intValues[2 * i + 1] = rand.nextLong();
                stringValues[2 * i] = words[rand.nextInt(words.length)];
                stringValues[2 * i + 1] = words[rand.nextInt(words.length)];
            }
            for (i = 0; i < count; ++i) {
                doubleValues[i] = rand.nextDouble();
                byte[] buf = new byte[20];
                rand.nextBytes(buf);
                byteValues[i] = new BytesWritable(buf);
            }
            for (i = 0; i < count; ++i) {
                OrcTestUtils.ReallyBigRow bigrow = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i);
                writer.addRow((Object)bigrow);
            }
            writer.close();
            writer = null;
            return inputs;
        }
    }

    private void compareRowsUsingPrimitives(OrcTestUtils.ReallyBigRow expected, OrcLazyBoolean boolean1, OrcLazyShort short1, OrcLazyInt int1, OrcLazyLong long1, OrcLazyShort short2, OrcLazyInt int2, OrcLazyLong long2, OrcLazyShort short3, OrcLazyInt int3, OrcLazyLong long3, OrcLazyFloat float1, OrcLazyDouble double1) throws IOException {
        try {
            boolean b1 = boolean1.materializeBoolean();
            Assert.assertEquals((boolean)expected.boolean1, (boolean)b1);
        }
        catch (IOException e) {
            assert (boolean1.nextIsNull());
            Assert.assertNull((Object)expected.boolean1);
        }
        if (short1.nextIsNull()) {
            Assert.assertNull((Object)expected.short1);
        } else {
            Assert.assertEquals((short)expected.short1, (short)((ShortWritable)short1.materialize()).get());
        }
        try {
            int i1 = int1.materializeInt();
            Assert.assertEquals((int)expected.int1, (int)i1);
        }
        catch (IOException e) {
            assert (int1.nextIsNull());
            Assert.assertNull((Object)expected.int1);
        }
        try {
            long l1 = long1.materializeLong();
            Assert.assertEquals((long)expected.long1, (long)l1);
        }
        catch (IOException e) {
            assert (long1.nextIsNull());
            Assert.assertNull((Object)expected.long1);
        }
        try {
            short s2 = short2.materializeShort();
            Assert.assertEquals((short)expected.short2, (short)s2);
        }
        catch (IOException e) {
            assert (short2.nextIsNull());
            Assert.assertNull((Object)expected.short2);
        }
        try {
            int i2 = int2.materializeInt();
            Assert.assertEquals((int)expected.int2, (int)i2);
        }
        catch (IOException e) {
            assert (int2.nextIsNull());
            Assert.assertNull((Object)expected.int2);
        }
        try {
            long l2 = long2.materializeLong();
            Assert.assertEquals((long)expected.long2, (long)l2);
        }
        catch (IOException e) {
            assert (long2.nextIsNull());
            Assert.assertNull((Object)expected.long2);
        }
        try {
            short s3 = short3.materializeShort();
            Assert.assertEquals((short)expected.short3, (short)s3);
        }
        catch (IOException e) {
            assert (short3.nextIsNull());
            Assert.assertNull((Object)expected.short3);
        }
        try {
            int i3 = int3.materializeInt();
            Assert.assertEquals((int)expected.int3, (int)i3);
        }
        catch (IOException e) {
            assert (int3.nextIsNull());
            Assert.assertNull((Object)expected.int3);
        }
        try {
            long l3 = long3.materializeLong();
            Assert.assertEquals((long)expected.long3, (long)l3);
        }
        catch (IOException e) {
            assert (long3.nextIsNull());
            Assert.assertNull((Object)expected.long3);
        }
        try {
            float f1 = float1.materializeFloat();
            Assert.assertEquals((double)expected.float1.floatValue(), (double)f1, (double)1.0E-4);
        }
        catch (IOException e) {
            assert (float1.nextIsNull());
            Assert.assertNull((Object)expected.float1);
        }
        try {
            double d1 = double1.materializeDouble();
            Assert.assertEquals((double)expected.double1, (double)d1, (double)1.0E-4);
        }
        catch (IOException e) {
            assert (double1.nextIsNull());
            Assert.assertNull((Object)expected.double1);
        }
    }

    private void compareRows(OrcStruct row, RandomRowInputs inputs, int rowNumber, NumberOfNulls numNulls, boolean testPrimitives) throws Exception {
        OrcTestUtils.ReallyBigRow expected = null;
        switch (numNulls) {
            case MANY: 
            case SOME: {
                expected = this.createRandomRowWithNulls(inputs.intValues, inputs.doubleValues, inputs.stringValues, inputs.byteValues, inputs.words, rowNumber, numNulls);
                break;
            }
            case NONE: {
                expected = this.createRandomRow(inputs.intValues, inputs.doubleValues, inputs.stringValues, inputs.byteValues, inputs.words, rowNumber);
            }
        }
        OrcLazyBoolean boolean1 = (OrcLazyBoolean)row.getFieldValue(0);
        if (boolean1.nextIsNull()) {
            Assert.assertNull((Object)expected.boolean1);
        } else {
            Assert.assertEquals((boolean)expected.boolean1, (boolean)((BooleanWritable)boolean1.materialize()).get());
        }
        if (((OrcLazyObject)row.getFieldValue(1)).nextIsNull()) {
            Assert.assertNull((Object)expected.byte1);
        } else {
            Assert.assertEquals((byte)expected.byte1, (byte)((ByteWritable)((OrcLazyByte)row.getFieldValue(1)).materialize()).get());
        }
        OrcLazyShort short1 = (OrcLazyShort)row.getFieldValue(2);
        try {
            short s1 = short1.materializeShort();
            Assert.assertEquals((short)expected.short1, (short)s1);
        }
        catch (IOException e) {
            assert (short1.nextIsNull());
            Assert.assertNull((Object)expected.short1);
        }
        OrcLazyInt int1 = (OrcLazyInt)row.getFieldValue(3);
        if (int1.nextIsNull()) {
            Assert.assertNull((Object)expected.int1);
        } else {
            Assert.assertEquals((int)expected.int1, (int)((IntWritable)int1.materialize()).get());
        }
        OrcLazyLong long1 = (OrcLazyLong)row.getFieldValue(4);
        if (long1.nextIsNull()) {
            Assert.assertNull((Object)expected.long1);
        } else {
            Assert.assertEquals((long)expected.long1, (long)((LongWritable)long1.materialize()).get());
        }
        OrcLazyShort short2 = (OrcLazyShort)row.getFieldValue(5);
        if (short2.nextIsNull()) {
            Assert.assertNull((Object)expected.short2);
        } else {
            Assert.assertEquals((short)expected.short2, (short)((ShortWritable)short2.materialize()).get());
        }
        OrcLazyInt int2 = (OrcLazyInt)row.getFieldValue(6);
        if (int2.nextIsNull()) {
            Assert.assertNull((Object)expected.int2);
        } else {
            Assert.assertEquals((int)expected.int2, (int)((IntWritable)int2.materialize()).get());
        }
        OrcLazyLong long2 = (OrcLazyLong)row.getFieldValue(7);
        if (long2.nextIsNull()) {
            Assert.assertNull((Object)expected.long2);
        } else {
            Assert.assertEquals((long)expected.long2, (long)((LongWritable)long2.materialize()).get());
        }
        OrcLazyShort short3 = (OrcLazyShort)row.getFieldValue(8);
        if (short3.nextIsNull()) {
            Assert.assertNull((Object)expected.short3);
        } else {
            Assert.assertEquals((short)expected.short3, (short)((ShortWritable)short3.materialize()).get());
        }
        OrcLazyInt int3 = (OrcLazyInt)row.getFieldValue(9);
        if (int3.nextIsNull()) {
            Assert.assertNull((Object)expected.int3);
        } else {
            Assert.assertEquals((int)expected.int3, (int)((IntWritable)int3.materialize()).get());
        }
        OrcLazyLong long3 = (OrcLazyLong)row.getFieldValue(10);
        if (long3.nextIsNull()) {
            Assert.assertNull((Object)expected.long3);
        } else {
            Assert.assertEquals((long)expected.long3, (long)((LongWritable)long3.materialize()).get());
        }
        OrcLazyFloat float1 = (OrcLazyFloat)row.getFieldValue(11);
        if (float1.nextIsNull()) {
            Assert.assertNull((Object)expected.float1);
        } else {
            Assert.assertEquals((double)expected.float1.floatValue(), (double)((FloatWritable)float1.materialize()).get(), (double)1.0E-4);
        }
        OrcLazyDouble double1 = (OrcLazyDouble)row.getFieldValue(12);
        if (double1.nextIsNull()) {
            Assert.assertNull((Object)expected.double1);
        } else {
            Assert.assertEquals((double)expected.double1, (double)((DoubleWritable)double1.materialize()).get(), (double)1.0E-4);
        }
        if (((OrcLazyObject)row.getFieldValue(13)).nextIsNull()) {
            Assert.assertNull((Object)expected.bytes1);
        } else {
            Assert.assertEquals((Object)expected.bytes1, (Object)((OrcLazyBinary)row.getFieldValue(13)).materialize());
        }
        if (((OrcLazyObject)row.getFieldValue(14)).nextIsNull()) {
            Assert.assertNull((Object)expected.string1);
        } else {
            Assert.assertEquals((Object)expected.string1, (Object)((OrcLazyString)row.getFieldValue(14)).materialize());
        }
        if (((OrcLazyString)row.getFieldValue(15)).nextIsNull()) {
            Assert.assertNull((Object)expected.string2);
        } else {
            Assert.assertEquals((Object)expected.string2, (Object)((OrcLazyString)row.getFieldValue(15)).materialize());
        }
        if (((OrcLazyString)row.getFieldValue(16)).nextIsNull()) {
            Assert.assertNull((Object)expected.string3);
        } else {
            Assert.assertEquals((Object)expected.string3, (Object)((OrcLazyString)row.getFieldValue(16)).materialize());
        }
        if (((OrcLazyObject)row.getFieldValue(17)).nextIsNull()) {
            Assert.assertNull((Object)expected.middle);
        } else {
            List<OrcTestUtils.InnerStruct> expectedList = expected.middle.list;
            OrcStruct actualMiddle = (OrcStruct)((OrcLazyStruct)row.getFieldValue(17)).materialize();
            List actualList = (List)actualMiddle.getFieldValue(0);
            this.compareListOfStructs(expectedList, actualList);
            List actualFieldNames = actualMiddle.getFieldNames();
            ArrayList<String> expectedFieldNames = new ArrayList<String>();
            expectedFieldNames.add("list");
            this.compareLists(expectedFieldNames, actualFieldNames);
        }
        if (((OrcLazyObject)row.getFieldValue(18)).nextIsNull()) {
            Assert.assertNull(expected.list);
        } else {
            this.compareListOfStructs(expected.list, (List)((OrcLazyList)row.getFieldValue(18)).materialize());
        }
        if (((OrcLazyObject)row.getFieldValue(19)).nextIsNull()) {
            Assert.assertNull(expected.map);
        } else {
            this.compareMap(expected.map, (Map)((OrcLazyMap)row.getFieldValue(19)).materialize());
        }
        if (testPrimitives) {
            this.compareRowsUsingPrimitives(expected, boolean1, short1, int1, long1, short2, int2, long2, short3, int3, long3, float1, double1);
        }
    }

    private void compareRowsWithoutNextIsNull(OrcStruct row, RandomRowInputs inputs, int rowNumber, NumberOfNulls numNulls, boolean usingPrimitives) throws Exception {
        OrcTestUtils.ReallyBigRow expected = null;
        switch (numNulls) {
            case MANY: 
            case SOME: {
                expected = this.createRandomRowWithNulls(inputs.intValues, inputs.doubleValues, inputs.stringValues, inputs.byteValues, inputs.words, rowNumber, numNulls);
                break;
            }
            case NONE: {
                expected = this.createRandomRow(inputs.intValues, inputs.doubleValues, inputs.stringValues, inputs.byteValues, inputs.words, rowNumber);
            }
        }
        OrcLazyBoolean lazyBoolean1 = (OrcLazyBoolean)row.getFieldValue(0);
        BooleanWritable boolean1 = (BooleanWritable)lazyBoolean1.materialize();
        if (boolean1 == null) {
            Assert.assertNull((Object)expected.boolean1);
        } else {
            Assert.assertEquals((boolean)expected.boolean1, (boolean)boolean1.get());
        }
        ByteWritable byte1 = (ByteWritable)((OrcLazyByte)row.getFieldValue(1)).materialize();
        if (byte1 == null) {
            Assert.assertNull((Object)expected.byte1);
        } else {
            Assert.assertEquals((byte)expected.byte1, (byte)byte1.get());
        }
        OrcLazyShort lazyShort1 = (OrcLazyShort)row.getFieldValue(2);
        ShortWritable short1 = (ShortWritable)lazyShort1.materialize();
        if (short1 == null) {
            Assert.assertNull((Object)expected.short1);
        } else {
            Assert.assertEquals((short)expected.short1, (short)short1.get());
        }
        OrcLazyInt lazyInt1 = (OrcLazyInt)row.getFieldValue(3);
        IntWritable int1 = (IntWritable)lazyInt1.materialize();
        if (int1 == null) {
            Assert.assertNull((Object)expected.int1);
        } else {
            Assert.assertEquals((int)expected.int1, (int)int1.get());
        }
        OrcLazyLong lazyLong1 = (OrcLazyLong)row.getFieldValue(4);
        LongWritable long1 = (LongWritable)lazyLong1.materialize();
        if (long1 == null) {
            Assert.assertNull((Object)expected.long1);
        } else {
            Assert.assertEquals((long)expected.long1, (long)long1.get());
        }
        OrcLazyShort lazyShort2 = (OrcLazyShort)row.getFieldValue(5);
        ShortWritable short2 = (ShortWritable)lazyShort2.materialize();
        if (short2 == null) {
            Assert.assertNull((Object)expected.short2);
        } else {
            Assert.assertEquals((short)expected.short2, (short)short2.get());
        }
        OrcLazyInt lazyInt2 = (OrcLazyInt)row.getFieldValue(6);
        IntWritable int2 = (IntWritable)lazyInt2.materialize();
        if (int2 == null) {
            Assert.assertNull((Object)expected.int2);
        } else {
            Assert.assertEquals((int)expected.int2, (int)int2.get());
        }
        OrcLazyLong lazyLong2 = (OrcLazyLong)row.getFieldValue(7);
        LongWritable long2 = (LongWritable)lazyLong2.materialize();
        if (long2 == null) {
            Assert.assertNull((Object)expected.long2);
        } else {
            Assert.assertEquals((long)expected.long2, (long)long2.get());
        }
        OrcLazyShort lazyShort3 = (OrcLazyShort)row.getFieldValue(8);
        ShortWritable short3 = (ShortWritable)lazyShort3.materialize();
        if (short3 == null) {
            Assert.assertNull((Object)expected.short3);
        } else {
            Assert.assertEquals((short)expected.short3, (short)short3.get());
        }
        OrcLazyInt lazyInt3 = (OrcLazyInt)row.getFieldValue(9);
        IntWritable int3 = (IntWritable)lazyInt3.materialize();
        if (int3 == null) {
            Assert.assertNull((Object)expected.int3);
        } else {
            Assert.assertEquals((int)expected.int3, (int)int3.get());
        }
        OrcLazyLong lazyLong3 = (OrcLazyLong)row.getFieldValue(10);
        LongWritable long3 = (LongWritable)lazyLong3.materialize();
        if (long3 == null) {
            Assert.assertNull((Object)expected.long3);
        } else {
            Assert.assertEquals((long)expected.long3, (long)long3.get());
        }
        OrcLazyFloat lazyFloat1 = (OrcLazyFloat)row.getFieldValue(11);
        FloatWritable float1 = (FloatWritable)lazyFloat1.materialize();
        if (float1 == null) {
            Assert.assertNull((Object)expected.float1);
        } else {
            Assert.assertEquals((double)expected.float1.floatValue(), (double)float1.get(), (double)1.0E-4);
        }
        OrcLazyDouble lazyDouble1 = (OrcLazyDouble)row.getFieldValue(12);
        DoubleWritable double1 = (DoubleWritable)lazyDouble1.materialize();
        if (double1 == null) {
            Assert.assertNull((Object)expected.double1);
        } else {
            Assert.assertEquals((double)expected.double1, (double)double1.get(), (double)1.0E-4);
        }
        BytesWritable bytes1 = (BytesWritable)((OrcLazyBinary)row.getFieldValue(13)).materialize();
        if (bytes1 == null) {
            Assert.assertNull((Object)expected.bytes1);
        } else {
            Assert.assertEquals((Object)expected.bytes1, (Object)bytes1);
        }
        Text string1 = (Text)((OrcLazyString)row.getFieldValue(14)).materialize();
        if (string1 == null) {
            Assert.assertNull((Object)expected.string1);
        } else {
            Assert.assertEquals((Object)expected.string1, (Object)string1);
        }
        Text string2 = (Text)((OrcLazyString)row.getFieldValue(15)).materialize();
        if (string2 == null) {
            Assert.assertNull((Object)expected.string2);
        } else {
            Assert.assertEquals((Object)expected.string2, (Object)string2);
        }
        Text string3 = (Text)((OrcLazyString)row.getFieldValue(16)).materialize();
        if (string3 == null) {
            Assert.assertNull((Object)expected.string3);
        } else {
            Assert.assertEquals((Object)expected.string3, (Object)string3);
        }
        OrcStruct middle = (OrcStruct)((OrcLazyStruct)row.getFieldValue(17)).materialize();
        if (middle == null) {
            Assert.assertNull((Object)expected.middle);
        } else {
            List<OrcTestUtils.InnerStruct> expectedList = expected.middle.list;
            List actualList = (List)middle.getFieldValue(0);
            this.compareListOfStructs(expectedList, actualList);
            List actualFieldNames = middle.getFieldNames();
            ArrayList<String> expectedFieldNames = new ArrayList<String>();
            expectedFieldNames.add("list");
            this.compareLists(expectedFieldNames, actualFieldNames);
        }
        List list = (List)((OrcLazyList)row.getFieldValue(18)).materialize();
        if (list == null) {
            Assert.assertNull(expected.list);
        } else {
            this.compareListOfStructs(expected.list, list);
        }
        Map map = (Map)((OrcLazyMap)row.getFieldValue(19)).materialize();
        if (map == null) {
            Assert.assertNull(expected.map);
        } else {
            this.compareMap(expected.map, map);
        }
        if (usingPrimitives) {
            this.compareRowsUsingPrimitives(expected, lazyBoolean1, lazyShort1, lazyInt1, lazyLong1, lazyShort2, lazyInt2, lazyLong2, lazyShort3, lazyInt3, lazyLong3, lazyFloat1, lazyDouble1);
        }
    }

    @Test
    public void testSeek() throws Exception {
        this.testSeek(false, true, false);
    }

    @Test
    public void testSeekLowMemory() throws Exception {
        this.testSeek(true, false, false);
    }

    @Test
    public void testSeekLazyHdfsReads() throws Exception {
        this.testSeek(false, false, true);
    }

    private void testSeek(boolean lowMemory, boolean testPrimitives, boolean lazyHdfsReads) throws Exception {
        int COUNT = 32768;
        RandomRowInputs inputs = this.writeRandomRows(32768, lowMemory);
        OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_EAGER_HDFS_READ, (!lazyHdfsReads ? 1 : 0) != 0);
        Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
        Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
        RecordReader rows = reader.rows(null);
        OrcLazyStruct lazyRow = null;
        OrcStruct row = null;
        for (int i = Short.MAX_VALUE; i >= 0; --i) {
            rows.seekToRow((long)i);
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            this.compareRows(row, inputs, i, NumberOfNulls.NONE, testPrimitives);
        }
        rows.close();
    }

    private void readEveryNthRow(int n, boolean withoutNextIsNull, NumberOfNulls numNulls) throws Exception {
        int COUNT = 32768;
        RandomRowInputs inputs = null;
        switch (numNulls) {
            case NONE: {
                inputs = this.writeRandomRows(32768, false);
                break;
            }
            case MANY: 
            case SOME: {
                inputs = this.writeRandomRowsWithNulls(32768, numNulls, false);
            }
        }
        Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
        Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
        RecordReader rows = reader.rows(null);
        OrcLazyStruct lazyRow = null;
        OrcStruct row = null;
        for (int i = 0; i < 32768; ++i) {
            rows.seekToRow((long)i);
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            if (i % n != 0) continue;
            row = (OrcStruct)lazyRow.materialize();
            if (withoutNextIsNull) {
                this.compareRowsWithoutNextIsNull(row, inputs, i, numNulls, true);
                continue;
            }
            this.compareRows(row, inputs, i, numNulls, true);
        }
        rows.close();
    }

    @Test
    public void testEveryRow() throws Exception {
        this.readEveryNthRow(1, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryOtherRow() throws Exception {
        this.readEveryNthRow(2, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryThirdRow() throws Exception {
        this.readEveryNthRow(3, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryFourthRow() throws Exception {
        this.readEveryNthRow(4, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryFifthRow() throws Exception {
        this.readEveryNthRow(5, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEverySixthRow() throws Exception {
        this.readEveryNthRow(6, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEverySeventhRow() throws Exception {
        this.readEveryNthRow(7, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryEighthRow() throws Exception {
        this.readEveryNthRow(8, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryNinthRow() throws Exception {
        this.readEveryNthRow(9, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryTenthRow() throws Exception {
        this.readEveryNthRow(10, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryHundredthRow() throws Exception {
        this.readEveryNthRow(100, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryThousandthRow() throws Exception {
        this.readEveryNthRow(1000, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryTenThousandthRow() throws Exception {
        this.readEveryNthRow(10000, false, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(1, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryOtherRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(2, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryThirdRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(3, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryFourthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(4, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryFifthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(5, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEverySixthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(6, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEverySeventhRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(7, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryEighthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(8, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryNinthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(9, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryTenthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(10, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryHundredthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(100, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryThousandthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(1000, true, NumberOfNulls.NONE);
    }

    @Test
    public void testEveryTenThousandthRowWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(10000, true, NumberOfNulls.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomRowInputs writeRandomRowsWithNulls(int count, NumberOfNulls numNulls, boolean lowMemoryMode) throws IOException {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.ReallyBigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, lowMemoryMode ? 200000L : 4000000L, CompressionKind.ZLIB, 65536, 1000, new MemoryManager(this.conf));
            Random rand = new Random(42L);
            RandomRowInputs inputs = new RandomRowInputs(count);
            long[] intValues = inputs.intValues;
            double[] doubleValues = inputs.doubleValues;
            String[] stringValues = inputs.stringValues;
            BytesWritable[] byteValues = inputs.byteValues;
            String[] words = inputs.words;
            for (i = 0; i < words.length; ++i) {
                words[i] = Integer.toHexString(rand.nextInt());
            }
            for (i = 0; i < count / 2; ++i) {
                intValues[2 * i] = rand.nextLong();
                intValues[2 * i + 1] = rand.nextLong();
                stringValues[2 * i] = words[rand.nextInt(words.length)];
                stringValues[2 * i + 1] = words[rand.nextInt(words.length)];
            }
            for (i = 0; i < count; ++i) {
                doubleValues[i] = rand.nextDouble();
                byte[] buf = new byte[20];
                rand.nextBytes(buf);
                byteValues[i] = new BytesWritable(buf);
            }
            for (i = 0; i < count; ++i) {
                OrcTestUtils.ReallyBigRow bigrow = this.createRandomRowWithNulls(intValues, doubleValues, stringValues, byteValues, words, i, numNulls);
                writer.addRow((Object)bigrow);
            }
            writer.close();
            writer = null;
            return inputs;
        }
    }

    @Test
    public void testEveryRowWithNulls() throws Exception {
        this.readEveryNthRow(1, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryOtherRowWithNulls() throws Exception {
        this.readEveryNthRow(2, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryThirdRowWithNulls() throws Exception {
        this.readEveryNthRow(3, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryFourthRowWithNulls() throws Exception {
        this.readEveryNthRow(4, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryFifthRowWithNulls() throws Exception {
        this.readEveryNthRow(5, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEverySixthRowWithNulls() throws Exception {
        this.readEveryNthRow(6, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEverySeventhRowWithNulls() throws Exception {
        this.readEveryNthRow(7, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryEighthRowWithNulls() throws Exception {
        this.readEveryNthRow(8, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryNinthRowWithNulls() throws Exception {
        this.readEveryNthRow(9, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryTenthRowWithNulls() throws Exception {
        this.readEveryNthRow(10, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryHundredthRowWithNulls() throws Exception {
        this.readEveryNthRow(100, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryThousandthRowWithNulls() throws Exception {
        this.readEveryNthRow(1000, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryTenThousandthRowWithNulls() throws Exception {
        this.readEveryNthRow(10000, false, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(1, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryOtherRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(2, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryThirdRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(3, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryFourthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(4, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryFifthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(5, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEverySixthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(6, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEverySeventhRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(7, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryEighthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(8, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryNinthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(9, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryTenthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(10, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryHundredthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(100, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryThousandthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(1000, true, NumberOfNulls.SOME);
    }

    @Test
    public void testEveryTenThousandthRowWithNullsWithoutNextIsNull() throws Exception {
        this.readEveryNthRow(10000, true, NumberOfNulls.SOME);
    }

    private void skipEveryNthRow(int n, boolean withoutNextIsNull, NumberOfNulls numNulls) throws Exception {
        int COUNT = 32768;
        RandomRowInputs inputs = null;
        switch (numNulls) {
            case NONE: {
                inputs = this.writeRandomRows(32768, false);
                break;
            }
            case MANY: 
            case SOME: {
                inputs = this.writeRandomRowsWithNulls(32768, numNulls, false);
            }
        }
        Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
        Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
        RecordReader rows = reader.rows(null);
        OrcLazyRow lazyRow = null;
        OrcStruct row = null;
        for (int i = 0; i < 32768; ++i) {
            lazyRow = (OrcLazyRow)rows.next(lazyRow);
            if (i % n == 0) continue;
            row = (OrcStruct)lazyRow.materialize();
            if (withoutNextIsNull) {
                this.compareRowsWithoutNextIsNull(row, inputs, i, numNulls, false);
                continue;
            }
            this.compareRows(row, inputs, i, numNulls, false);
        }
        rows.close();
    }

    @Test
    public void testEveryRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(1, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryOtherRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(2, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryThirdRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(3, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryFourthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(4, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryFifthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(5, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEverySixthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(6, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEverySeventhRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(7, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryEighthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(8, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryNinthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(9, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryTenthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(10, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryHundredthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(100, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryThousandthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(1000, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryTenThousandthRowWithLotsOfNulls() throws Exception {
        this.skipEveryNthRow(10000, false, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(1, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryOtherRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(2, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryThirdRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(3, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryFourthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(4, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryFifthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(5, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEverySixthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(6, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEverySeventhRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(7, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryEighthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(8, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryNinthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(9, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryTenthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(10, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryHundredthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(100, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryThousandthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(1000, true, NumberOfNulls.MANY);
    }

    @Test
    public void testEveryTenThousandthRowWithLotsOfNullsWithoutNextIsNull() throws Exception {
        this.skipEveryNthRow(10000, true, NumberOfNulls.MANY);
    }

    private void compareInner(OrcTestUtils.InnerStruct expect, OrcStruct actual) throws Exception {
        if (expect == null || actual == null) {
            Assert.assertEquals((Object)expect, (Object)actual);
        } else {
            if (actual.getFieldValue(0) == null) {
                Assert.assertNull((Object)expect.int1);
            } else {
                Assert.assertEquals((int)expect.int1, (int)((IntWritable)actual.getFieldValue(0)).get());
            }
            Assert.assertEquals((Object)expect.string1, (Object)actual.getFieldValue(1));
        }
    }

    private void compareListOfStructs(List<OrcTestUtils.InnerStruct> expect, List<OrcStruct> actual) throws Exception {
        Assert.assertEquals((int)expect.size(), (int)actual.size());
        for (int j = 0; j < expect.size(); ++j) {
            this.compareInner(expect.get(j), actual.get(j));
        }
    }

    private void compareLists(List expect, List actual) throws Exception {
        Assert.assertEquals((int)expect.size(), (int)actual.size());
        Assert.assertTrue((boolean)expect.containsAll(actual));
    }

    private void compareMap(Map<Text, OrcTestUtils.InnerStruct> expect, Map<Text, OrcStruct> actual) throws Exception {
        Assert.assertEquals((int)expect.size(), (int)actual.size());
        for (Text key : expect.keySet()) {
            this.compareInner(expect.get(key), actual.get(key));
        }
    }

    private OrcTestUtils.ReallyBigRow createRandomRow(long[] intValues, double[] doubleValues, String[] stringValues, BytesWritable[] byteValues, String[] words, int i) {
        OrcTestUtils.InnerStruct inner = new OrcTestUtils.InnerStruct((int)intValues[i], stringValues[i]);
        OrcTestUtils.InnerStruct inner2 = new OrcTestUtils.InnerStruct((int)(intValues[i] >> 32), words[i % words.length] + "-x");
        String stringWithUniques = i % 10 == 0 ? Integer.toHexString(i) : stringValues[i];
        Short shortWithUniques = i % 10 == 0 ? (short)i : (short)(intValues[i] % 10L);
        Integer intWithUniques = i % 10 == 0 ? Short.MAX_VALUE + i : (int)(32767L + intValues[i] % 10L);
        Long longWithUniques = i % 10 == 0 ? (long)(Integer.MAX_VALUE + i) : Integer.MAX_VALUE + intValues[i] % 10L;
        return new OrcTestUtils.ReallyBigRow((intValues[i] & 1L) == 0L, (byte)intValues[i], (short)intValues[i], (int)(32767L + intValues[i]), Integer.MAX_VALUE + intValues[i], (short)(intValues[i] % 10L), (int)(32767L + intValues[i] % 10L), Integer.MAX_VALUE + intValues[i] % 10L, shortWithUniques, intWithUniques, longWithUniques, Float.valueOf((float)doubleValues[i]), doubleValues[i], byteValues[i], stringValues[i], Integer.toHexString(i), stringWithUniques, new OrcTestUtils.MiddleStruct(inner, inner2), OrcTestUtils.list(new OrcTestUtils.InnerStruct[0]), OrcTestUtils.map(inner, inner2));
    }

    private OrcTestUtils.ReallyBigRow createRandomRowWithNulls(long[] intValues, double[] doubleValues, String[] stringValues, BytesWritable[] byteValues, String[] words, int i, NumberOfNulls numNulls) {
        boolean lotsOfNulls;
        Boolean booleanVal = intValues[i] % 10L == 0L ^ (lotsOfNulls = numNulls == NumberOfNulls.MANY) ? null : Boolean.valueOf((intValues[i] & 1L) == 0L);
        Byte byteVal = intValues[i] % 11L == 0L ^ lotsOfNulls ? null : Byte.valueOf((byte)intValues[i]);
        Short shortVal = intValues[i] % 12L == 0L ^ lotsOfNulls ? null : Short.valueOf((short)intValues[i]);
        Integer intVal = intValues[i] % 13L == 0L ^ lotsOfNulls ? null : Integer.valueOf(Short.MAX_VALUE + i);
        Long longVal = intValues[i] % 14L == 0L ^ lotsOfNulls ? null : Long.valueOf(Integer.MAX_VALUE + i);
        Float floatVal = intValues[i] % 15L == 0L ^ lotsOfNulls ? null : Float.valueOf((float)doubleValues[i]);
        Double doubleVal = intValues[i] % 16L == 0L ^ lotsOfNulls ? null : Double.valueOf(doubleValues[i]);
        BytesWritable bytesVal = intValues[i] % 17L == 0L ^ lotsOfNulls ? null : byteValues[i];
        String strVal = intValues[i] % 18L == 0L ^ lotsOfNulls ? null : stringValues[i];
        OrcTestUtils.InnerStruct inner = intValues[i] % 19L == 0L ^ lotsOfNulls ? null : new OrcTestUtils.InnerStruct(intValues[i] % 10L == 0L ^ lotsOfNulls ? null : Integer.valueOf((int)intValues[i]), intValues[i] % 11L == 0L ^ lotsOfNulls ? null : stringValues[i]);
        OrcTestUtils.InnerStruct inner2 = intValues[i] % 12L == 0L ^ lotsOfNulls ? null : new OrcTestUtils.InnerStruct(intValues[i] % 13L == 0L ^ lotsOfNulls ? null : Integer.valueOf((int)(intValues[i] >> 32)), intValues[i] % 14L == 0L ^ lotsOfNulls ? null : words[i % words.length] + "-x");
        OrcTestUtils.MiddleStruct middle = intValues[i] % 15L == 0L ^ lotsOfNulls ? null : new OrcTestUtils.MiddleStruct(inner, inner2);
        List<OrcTestUtils.InnerStruct> list = intValues[i] % 16L == 0L ^ lotsOfNulls ? null : OrcTestUtils.list(inner, inner2);
        Map<Text, OrcTestUtils.InnerStruct> map = intValues[i] % 17L == 0L ^ lotsOfNulls ? null : OrcTestUtils.map(inner, inner2);
        String strVal2 = intValues[i] % 18L == 0L ^ lotsOfNulls ? null : Integer.toHexString(i);
        Short shortVal2 = intValues[i] % 19L == 0L ^ lotsOfNulls ? null : Short.valueOf((short)(intValues[i] % 10L));
        Integer intVal2 = intValues[i] % 10L == 0L ^ lotsOfNulls ? null : Integer.valueOf((int)(32767L + intValues[i] % 10L));
        Long longVal2 = intValues[i] % 11L == 0L ^ lotsOfNulls ? null : Long.valueOf(Integer.MAX_VALUE + intValues[i] % 10L);
        String strVal3 = intValues[i] % 12L == 0L ^ lotsOfNulls ? null : (intValues[i] % 10L == 0L ? Integer.toHexString(i) : stringValues[i]);
        Short shortVal3 = intValues[i] % 13L == 0L ^ lotsOfNulls ? null : Short.valueOf(intValues[i] % 10L == 0L ? (short)i : (short)(intValues[i] % 10L));
        Integer intVal3 = intValues[i] % 14L == 0L ^ lotsOfNulls ? null : Integer.valueOf(intValues[i] % 10L == 0L ? Short.MAX_VALUE + i : (int)(32767L + intValues[i] % 10L));
        Long longVal3 = intValues[i] % 15L == 0L ^ lotsOfNulls ? null : Long.valueOf(intValues[i] % 10L == 0L ? (long)(Integer.MAX_VALUE + i) : Integer.MAX_VALUE + intValues[i] % 10L);
        return new OrcTestUtils.ReallyBigRow(booleanVal, byteVal, shortVal, intVal, longVal, shortVal2, intVal2, longVal2, shortVal3, intVal3, longVal3, floatVal, doubleVal, bytesVal, strVal, strVal2, strVal3, middle, list, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryManagement() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MyMemoryManager memory = new MyMemoryManager(this.conf, 10000L, 0.1);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 50000L, CompressionKind.NONE, 100, 0, (MemoryManager)memory);
            Assert.assertEquals((Object)this.testFilePath, (Object)memory.path);
            for (int i = 0; i < 2500; ++i) {
                writer.addRow((Object)new OrcTestUtils.InnerStruct(i * 300, Integer.toHexString(10 * i)));
            }
            writer.close();
            Assert.assertEquals(null, (Object)memory.path);
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            int i = 0;
            for (StripeInformation stripe : reader.getStripes()) {
                Assert.assertTrue((String)("stripe " + ++i + " is too long at " + stripe.getDataLength()), (stripe.getDataLength() < 6000L ? 1 : 0) != 0);
            }
            Assert.assertEquals((int)5, (int)i);
            Assert.assertEquals((long)2500L, (long)reader.getNumberOfRows());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyStringStrideDictionary() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.StringStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MemoryManagerWithForceFlush memory = new MemoryManagerWithForceFlush(this.conf);
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)1);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 1000000L, CompressionKind.NONE, 100, 1000, (MemoryManager)memory);
            writer.addRow((Object)new OrcTestUtils.StringStruct(""));
            for (int i = 0; i < 999; ++i) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((String)"", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            for (int i = 0; i < 999; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrideDictionariesWithoutStripeCarryover() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.StringStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MemoryManagerWithForceFlush memory = new MemoryManagerWithForceFlush(this.conf);
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)1);
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_ENCODING_INTERVAL, (int)2);
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_BUILD_STRIDE_DICTIONARY, (boolean)true);
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_SORT_KEYS, (boolean)true);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 1000000L, CompressionKind.NONE, 100, 1000, (MemoryManager)memory);
            for (i2 = 0; i2 < 2000; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct(Integer.toString(i2)));
            }
            memory.forceFlushStripe();
            for (i2 = 0; i2 < 2000; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct(Integer.toString(i2)));
            }
            memory.forceFlushStripe();
            writer.addRow((Object)new OrcTestUtils.StringStruct("b"));
            for (i2 = 0; i2 < 999; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            writer.addRow((Object)new OrcTestUtils.StringStruct("a"));
            for (i2 = 0; i2 < 999; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            memory.forceFlushStripe();
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            for (i = 0; i < 4000; ++i) {
                Assert.assertEquals((String)Integer.toString(i % 2000), (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
                rows.next((Object)lazyRow);
            }
            Assert.assertEquals((String)"b", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            for (i = 0; i < 999; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"a", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            for (i = 0; i < 999; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekAcrossStrideDictionaries() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.StringStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MemoryManagerWithForceFlush memory = new MemoryManagerWithForceFlush(this.conf);
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)1);
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_BUILD_STRIDE_DICTIONARY, (boolean)true);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 1000000L, CompressionKind.NONE, 100, 1000, (MemoryManager)memory);
            writer.addRow((Object)new OrcTestUtils.StringStruct("a"));
            for (i = 0; i < 999; ++i) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            writer.addRow((Object)new OrcTestUtils.StringStruct("b"));
            for (i = 0; i < 999; ++i) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            rows.next((Object)lazyRow);
            for (int i2 = 0; i2 < 999; ++i2) {
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
                rows.next((Object)lazyRow);
            }
            Assert.assertEquals((String)"b", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyInStringDictionaryStream() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.StringStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MemoryManagerWithForceFlush memory = new MemoryManagerWithForceFlush(this.conf);
            OrcConf.setIntVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)1);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 1000000L, CompressionKind.NONE, 100, 1000, (MemoryManager)memory);
            writer.addRow((Object)new OrcTestUtils.StringStruct("a"));
            writer.addRow((Object)new OrcTestUtils.StringStruct("b"));
            writer.addRow((Object)new OrcTestUtils.StringStruct("c"));
            for (i2 = 0; i2 < 997; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            memory.forceFlushStripe();
            for (i2 = 0; i2 < 1000; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            memory.forceFlushStripe();
            writer.addRow((Object)new OrcTestUtils.StringStruct("a"));
            writer.addRow((Object)new OrcTestUtils.StringStruct("b"));
            writer.addRow((Object)new OrcTestUtils.StringStruct("c"));
            for (i2 = 0; i2 < 997; ++i2) {
                writer.addRow((Object)new OrcTestUtils.StringStruct("123"));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((String)"a", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"b", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"c", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            for (i = 0; i < 997; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            for (i = 0; i < 1000; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"a", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"b", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            rows.next((Object)lazyRow);
            Assert.assertEquals((String)"c", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            for (i = 0; i < 997; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((String)"123", (String)((OrcLazyString)row.getFieldValue(0)).materialize().toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyInIntDictionaryStream() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.IntStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MemoryManagerWithForceFlush memory = new MemoryManagerWithForceFlush(this.conf);
            WriterImpl writer = new WriterImpl(this.fs, this.testFilePath, this.conf, inspector, 1000000L, CompressionKind.NONE, 100, 1000, (MemoryManager)memory);
            writer.addRow((Object)new OrcTestUtils.IntStruct(1));
            writer.addRow((Object)new OrcTestUtils.IntStruct(2));
            writer.addRow((Object)new OrcTestUtils.IntStruct(3));
            for (i2 = 0; i2 < 997; ++i2) {
                writer.addRow((Object)new OrcTestUtils.IntStruct(123));
            }
            memory.forceFlushStripe();
            for (i2 = 0; i2 < 1000; ++i2) {
                writer.addRow((Object)new OrcTestUtils.IntStruct(123));
            }
            memory.forceFlushStripe();
            writer.addRow((Object)new OrcTestUtils.IntStruct(1));
            writer.addRow((Object)new OrcTestUtils.IntStruct(2));
            writer.addRow((Object)new OrcTestUtils.IntStruct(3));
            for (i2 = 0; i2 < 997; ++i2) {
                writer.addRow((Object)new OrcTestUtils.IntStruct(123));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = null;
            OrcStruct row = null;
            lazyRow = (OrcLazyStruct)rows.next(lazyRow);
            row = (OrcStruct)lazyRow.materialize();
            Assert.assertEquals((int)1, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            rows.next((Object)lazyRow);
            Assert.assertEquals((int)2, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            rows.next((Object)lazyRow);
            Assert.assertEquals((int)3, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            for (i = 0; i < 997; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((int)123, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            }
            for (i = 0; i < 1000; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((int)123, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            }
            rows.next((Object)lazyRow);
            Assert.assertEquals((int)1, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            rows.next((Object)lazyRow);
            Assert.assertEquals((int)2, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            rows.next((Object)lazyRow);
            Assert.assertEquals((int)3, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            for (i = 0; i < 997; ++i) {
                rows.next((Object)lazyRow);
                Assert.assertEquals((int)123, (int)((IntWritable)((OrcLazyInt)row.getFieldValue(0)).materialize()).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipWithEmptyArrayInEnd() throws Exception {
        List<String> emptyList = Collections.emptyList();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(OrcTestUtils.StringListWithId.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            OrcConf.setFloatVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_KEY_STRING_SIZE_THRESHOLD, (float)0.01f);
            OrcConf.setBoolVar((Configuration)this.conf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_FILE_ENABLE_LOW_MEMORY_MODE, (boolean)false);
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)1000000L, (CompressionKind)CompressionKind.ZLIB, (int)1000, (int)1000);
            int numNulls = 4;
            int numNonNulls = 8;
            for (int i = 0; i < numNonNulls; ++i) {
                ArrayList<String> filledList = new ArrayList<String>();
                filledList.add("SomeText");
                filledList.add("SomeMoreText" + i);
                writer.addRow((Object)new OrcTestUtils.StringListWithId(i, filledList));
            }
            for (int j = 0; j < numNulls; ++j) {
                writer.addRow((Object)new OrcTestUtils.StringListWithId(numNonNulls + j, emptyList));
            }
            writer.close();
            Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf);
            RecordReader rows = reader.rows(null);
            OrcLazyStruct lazyRow = (OrcLazyStruct)rows.next(null);
            OrcStruct row = (OrcStruct)lazyRow.materialize();
            OrcLazyList list = (OrcLazyList)row.getFieldValue(1);
            LazyTreeReader lazyReader = list.getLazyTreeReader();
            Object prev = lazyReader.get((long)(numNonNulls - 1), null);
            boolean gotException = false;
            String expectedExceptionMessage = "Read past end of buffer RLE byte from compressed stream Stream for column 3 kind IN_DICTIONARY base: 60 limit: 66 current stride: 1 compressed offset: 66 uncompressed: 66 to 66";
            try {
                lazyReader.get((long)(numNonNulls + 1), prev);
            }
            catch (EOFException e) {
                if (e.getMessage().compareTo(expectedExceptionMessage) == 0) {
                    gotException = true;
                }
                throw e;
            }
            Assert.assertFalse((String)"Got EOFException for reading past end of buffer RLE byte", (boolean)gotException);
            return;
        }
    }

    private static class MemoryManagerWithForceFlush
    extends MemoryManager {
        MemoryManagerWithForceFlush(Configuration conf) {
            super(conf);
        }

        public void forceFlushStripe() throws IOException {
            for (MemoryManager.WriterInfo writer : this.writerList.values()) {
                writer.callback.checkMemory(0.0);
            }
        }
    }

    private static class MyMemoryManager
    extends MemoryManager {
        final long totalSpace;
        double rate;
        Path path = null;
        long lastAllocation = 0L;
        int rows = 0;
        MemoryManager.Callback callback;

        MyMemoryManager(Configuration conf, long totalSpace, double rate) {
            super(conf);
            this.totalSpace = totalSpace;
            this.rate = rate;
        }

        void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback, long initialAllocation) {
            this.path = path;
            this.lastAllocation = requestedAllocation;
            this.callback = callback;
        }

        synchronized void removeWriter(Path path) {
            this.path = null;
            this.lastAllocation = 0L;
        }

        long getTotalMemoryPool() {
            return this.totalSpace;
        }

        double getAllocationScale() {
            return this.rate;
        }

        void addedRow() throws IOException {
            if (++this.rows % 100 == 0) {
                this.callback.checkMemory(this.rate);
            }
        }
    }

    private static enum NumberOfNulls {
        NONE,
        SOME,
        MANY;

    }

    private static class RandomRowInputs {
        long[] intValues;
        double[] doubleValues;
        String[] stringValues;
        BytesWritable[] byteValues;
        String[] words = new String[128];

        public RandomRowInputs(int count) {
            this.intValues = new long[count];
            this.doubleValues = new double[count];
            this.stringValues = new String[count];
            this.byteValues = new BytesWritable[count];
        }
    }
}

