/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OutStream;
import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.PositionedOutputStream;
import com.facebook.hive.orc.RunLengthByteReader;
import com.facebook.hive.orc.RunLengthByteWriter;
import com.facebook.hive.orc.SnappyCodec;
import com.facebook.hive.orc.TestInStream;
import com.facebook.hive.orc.WriterImpl;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.junit.Test;

public class TestRunLengthByteReader {
    @Test
    public void testUncompressedSeek() throws Exception {
        int x;
        int i;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect));
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        for (int i2 = 0; i2 < 2048; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            if (i2 < 1024) {
                out.write((byte)(i2 / 4));
                continue;
            }
            out.write((byte)i2);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer)inBuf, null, (int)100));
        for (i = 0; i < 2048; ++i) {
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 2047; i >= 0; --i) {
            in.seek(i);
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
    }

    @Test
    public void testCompressedSeek() throws Exception {
        int x;
        int i;
        SnappyCodec codec = new SnappyCodec();
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 500, (CompressionCodec)codec, (OutStream.OutputReceiver)collect));
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        for (int i2 = 0; i2 < 2048; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            if (i2 < 1024) {
                out.write((byte)(i2 / 4));
                continue;
            }
            out.write((byte)i2);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)500));
        for (i = 0; i < 2048; ++i) {
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 2047; i >= 0; --i) {
            in.seek(i);
            x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4 & 0xFF), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthByteWriter out = new RunLengthByteWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect));
        for (int i = 0; i < 2048; ++i) {
            if (i < 1024) {
                out.write((byte)(i / 16));
                continue;
            }
            out.write((byte)i);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthByteReader in = new RunLengthByteReader(InStream.create((String)"test", (ByteBuffer)inBuf, null, (int)100));
        for (int i = 0; i < 2048; i += 10) {
            int x = in.next() & 0xFF;
            if (i < 1024) {
                Assert.assertEquals((int)(i / 16 & 0xFF), (int)x);
            } else {
                Assert.assertEquals((int)(i & 0xFF), (int)x);
            }
            if (i < 2038) {
                in.skip(9L);
            }
            in.skip(0L);
        }
    }
}

