/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.CompressionCodec;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OutStream;
import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.PositionedOutputStream;
import com.facebook.hive.orc.RunLengthIntegerReader;
import com.facebook.hive.orc.RunLengthIntegerWriter;
import com.facebook.hive.orc.TestInStream;
import com.facebook.hive.orc.WriterImpl;
import com.facebook.hive.orc.ZlibCodec;
import java.nio.ByteBuffer;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class TestRunLengthIntegerReader {
    public void runSeekTest(CompressionCodec codec) throws Exception {
        int x;
        int i;
        int i2;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthIntegerWriter out = new RunLengthIntegerWriter((PositionedOutputStream)new OutStream("test", 1000, codec, (OutStream.OutputReceiver)collect), true, 4, true);
        OrcProto.RowIndex.Builder rowIndex = OrcProto.RowIndex.newBuilder();
        OrcProto.RowIndexEntry.Builder rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
        WriterImpl.RowIndexPositionRecorder rowIndexPosition = new WriterImpl.RowIndexPositionRecorder(rowIndexEntry);
        Random random = new Random(99L);
        int[] junk = new int[2048];
        for (i2 = 0; i2 < junk.length; ++i2) {
            junk[i2] = random.nextInt();
        }
        for (i2 = 0; i2 < 4096; ++i2) {
            out.getPosition((PositionRecorder)rowIndexPosition);
            rowIndex.addEntry(rowIndexEntry.build());
            rowIndexEntry.clear();
            if (i2 < 1024) {
                out.write(i2 / 4);
                continue;
            }
            if (i2 < 2048) {
                out.write(2 * i2);
                continue;
            }
            out.write(junk[i2 - 2048]);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthIntegerReader in = new RunLengthIntegerReader(InStream.create((String)"test", (ByteBuffer)inBuf, (CompressionCodec)codec, (int)1000, (boolean)true), true, 4);
        for (i = 0; i < 2048; ++i) {
            x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4), (int)x);
                continue;
            }
            if (i < 2048) {
                Assert.assertEquals((int)(2 * i), (int)x);
                continue;
            }
            Assert.assertEquals((int)junk[i - 2048], (int)x);
        }
        in.loadIndeces(rowIndex.build().getEntryList(), 0);
        for (i = 2047; i >= 0; --i) {
            in.seek(i);
            x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4), (int)x);
                continue;
            }
            if (i < 2048) {
                Assert.assertEquals((int)(2 * i), (int)x);
                continue;
            }
            Assert.assertEquals((int)junk[i - 2048], (int)x);
        }
    }

    @Test
    public void testUncompressedSeek() throws Exception {
        this.runSeekTest(null);
    }

    @Test
    public void testCompressedSeek() throws Exception {
        this.runSeekTest((CompressionCodec)new ZlibCodec());
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthIntegerWriter out = new RunLengthIntegerWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect), true, 4, true);
        for (int i = 0; i < 2048; ++i) {
            if (i < 1024) {
                out.write(i);
                continue;
            }
            out.write(256 * i);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthIntegerReader in = new RunLengthIntegerReader(InStream.create((String)"test", (ByteBuffer)inBuf, null, (int)100, (boolean)true), true, 4);
        for (int i = 0; i < 2048; i += 10) {
            int x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)i, (int)x);
            } else {
                Assert.assertEquals((int)(256 * i), (int)x);
            }
            if (i < 2038) {
                in.skip(9L);
            }
            in.skip(0L);
        }
    }
}

