/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.DictionaryEncoder;
import com.facebook.hive.orc.StringDictionaryEncoder;
import com.facebook.hive.orc.TestBitFieldReader;
import com.facebook.hive.orc.TestDynamicArray;
import com.facebook.hive.orc.TestFileDump;
import com.facebook.hive.orc.TestInStream;
import com.facebook.hive.orc.TestInputOutputFormat;
import com.facebook.hive.orc.TestOrcFile;
import com.facebook.hive.orc.TestOrcStruct;
import com.facebook.hive.orc.TestRunLengthByteReader;
import com.facebook.hive.orc.TestRunLengthIntegerReader;
import com.facebook.hive.orc.TestSerializationUtils;
import com.facebook.hive.orc.TestStreamName;
import com.facebook.hive.orc.TestZlib;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestStringDictionaryEncoder {
    private void checkContent(StringDictionaryEncoder dictEncoder, String[] values, int[] order) throws Exception {
        dictEncoder.visit((DictionaryEncoder.Visitor)new TestVisitor(values, order));
    }

    private StringDictionaryEncoder buildDictionary(String[] values, boolean sortKeys) {
        StringDictionaryEncoder dictEncoder = new StringDictionaryEncoder(sortKeys, false);
        for (String value : values) {
            dictEncoder.add(new Text(value), 0);
        }
        return dictEncoder;
    }

    @Test
    public void test1() throws Exception {
        StringDictionaryEncoder dict = new StringDictionaryEncoder();
        String[] addKeys = new String[]{"owen", "ashutosh", "owen", "alan", "alan", "ashutosh", "greg", "eric", "arun", "eric14", "o", "ziggy", "z", "greg"};
        int[] addKPos = new int[]{0, 1, 0, 2, 2, 1, 3, 4, 5, 6, 7, 8, 9, 3};
        int[] sizes = new int[]{1, 2, 2, 3, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10};
        String[] expectedOrderedUniqueValues = new String[]{"alan", "arun", "ashutosh", "eric", "eric14", "greg", "o", "owen", "z", "ziggy"};
        int[] expectedOrder = new int[]{2, 5, 1, 4, 6, 3, 7, 0, 9, 8};
        for (int i = 0; i < addKeys.length; ++i) {
            int addPos = dict.add(new Text(addKeys[i]), 0);
            Assert.assertEquals((int)addPos, (int)addKPos[i]);
            Assert.assertEquals((int)sizes[i], (int)dict.size());
        }
        this.checkContent(dict, expectedOrderedUniqueValues, expectedOrder);
    }

    private void testUnsorted(boolean strideDictionaries) throws Exception {
        int i;
        StringDictionaryEncoder dict = new StringDictionaryEncoder(false, strideDictionaries);
        String[] addKeys = new String[]{"owen", "ashutosh", "owen", "alan", "alan", "ashutosh", "greg", "eric", "arun", "eric14", "o", "ziggy", "z"};
        int[] addKPos = new int[]{0, 1, 0, 2, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10};
        int[] sizes = new int[]{1, 2, 2, 3, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        String[] expectedUniqueValues = new String[]{"owen", "ashutosh", "alan", "greg", "eric", "arun", "eric14", "o", "ziggy", "z"};
        int[] expectedOrder = new int[addKeys.length];
        for (i = 0; i < addKeys.length; ++i) {
            expectedOrder[i] = i;
        }
        for (i = 0; i < addKeys.length; ++i) {
            int addPos = dict.add(new Text(addKeys[i]), 0);
            Assert.assertEquals((int)addPos, (int)addKPos[i]);
            Assert.assertEquals((int)sizes[i], (int)dict.size());
        }
        this.checkContent(dict, expectedUniqueValues, expectedOrder);
        dict.clear();
        Assert.assertEquals((long)688128L, (long)dict.getSizeInBytes());
        Assert.assertEquals((int)0, (int)dict.size());
    }

    @Test
    public void testSortedAcrossIndices() throws Exception {
        StringDictionaryEncoder dict = new StringDictionaryEncoder(true, true);
        String[] addKeys = new String[]{"owen", "ashutosh", "owen", "alan", "alan", "ashutosh", "greg", "eric", "arun", "eric14", "o", "ziggy", "z"};
        int[] addKPos = new int[]{0, 1, 0, 2, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10};
        int[] sizes = new int[]{1, 2, 2, 3, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        String[] expectedUniqueValues = new String[]{"eric14", "greg", "z", "eric", "o", "arun", "ziggy", "alan", "ashutosh", "owen"};
        int[] expectedOrder = new int[]{6, 3, 9, 4, 7, 5, 8, 2, 1, 0};
        for (int i = 0; i < addKeys.length; ++i) {
            int addPos = dict.add(new Text(addKeys[i]), i % 3);
            Assert.assertEquals((int)addPos, (int)addKPos[i]);
            Assert.assertEquals((int)sizes[i], (int)dict.size());
        }
        this.checkContent(dict, expectedUniqueValues, expectedOrder);
        dict.clear();
        Assert.assertEquals((long)688128L, (long)dict.getSizeInBytes());
        Assert.assertEquals((int)0, (int)dict.size());
    }

    @Test
    public void testUnsorted() throws Exception {
        this.testUnsorted(false);
    }

    @Test
    public void testUnsortedStrideDictionaries() throws Exception {
        this.testUnsorted(true);
    }

    @Test
    public void testSortedStrideDictionaries() throws Exception {
        StringDictionaryEncoder dict = new StringDictionaryEncoder(true, true);
        String[] addKeys = new String[]{"owen", "ashutosh", "owen", "alan", "alan", "ashutosh", "greg", "eric", "arun", "eric14", "o", "ziggy", "z"};
        int[] addKPos = new int[]{0, 1, 0, 2, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10};
        int[] sizes = new int[]{1, 2, 2, 3, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        String[] expectedUniqueValues = new String[]{"arun", "eric", "eric14", "greg", "o", "z", "ziggy", "alan", "ashutosh", "owen"};
        int[] expectedOrder = new int[]{5, 4, 6, 3, 7, 9, 8, 2, 1, 0};
        for (int i = 0; i < addKeys.length; ++i) {
            int addPos = dict.add(new Text(addKeys[i]), 0);
            Assert.assertEquals((int)addPos, (int)addKPos[i]);
            Assert.assertEquals((int)sizes[i], (int)dict.size());
        }
        this.checkContent(dict, expectedUniqueValues, expectedOrder);
        dict.clear();
        Assert.assertEquals((long)688128L, (long)dict.getSizeInBytes());
        Assert.assertEquals((int)0, (int)dict.size());
    }

    @Test
    public void test2() throws Exception {
        String[] v = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        StringDictionaryEncoder dict = this.buildDictionary(v, true);
        Assert.assertEquals((int)26, (int)dict.size());
        this.checkContent(dict, v, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25});
    }

    @Test
    public void test3() throws Exception {
        Object[] v = new String[]{"z", "y", "x", "w", "v", "u", "t", "s", "r", "q", "p", "o", "n", "m", "l", "k", "j", "i", "h", "g", "f", "e", "d", "c", "b", "a"};
        StringDictionaryEncoder dict = this.buildDictionary((String[])v, true);
        Assert.assertEquals((int)26, (int)dict.size());
        Arrays.sort(v);
        this.checkContent(dict, (String[])v, new int[]{25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
    }

    @Test
    public void test4() throws Exception {
        String[] v = new String[]{"z", "y", "x", "w", "v", "u", "t", "s", "r", "q", "p", "o", "n", "m", "l", "k", "j", "i", "h", "g", "f", "e", "d", "c", "b", "a"};
        StringDictionaryEncoder dict = this.buildDictionary(v, false);
        Assert.assertEquals((int)26, (int)dict.size());
        this.checkContent(dict, v, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25});
    }

    public static void main(String[] args) throws Exception {
        TestStringDictionaryEncoder test = new TestStringDictionaryEncoder();
        test.test1();
        test.test2();
        test.test3();
        test.test4();
        test.testUnsorted();
        TestSerializationUtils serUtils = new TestSerializationUtils();
        serUtils.TestDoubles();
        TestDynamicArray test6 = new TestDynamicArray();
        test6.testByteArray();
        test6.testIntArray();
        TestZlib zlib = new TestZlib();
        zlib.testCorrupt();
        zlib.testNoOverflow();
        TestInStream inStreamTest = new TestInStream();
        inStreamTest.testUncompressed();
        inStreamTest.testCompressed();
        inStreamTest.testCorruptStream();
        TestRunLengthByteReader rleByte = new TestRunLengthByteReader();
        rleByte.testUncompressedSeek();
        rleByte.testCompressedSeek();
        rleByte.testSkips();
        TestRunLengthIntegerReader rleInt = new TestRunLengthIntegerReader();
        rleInt.testUncompressedSeek();
        rleInt.testCompressedSeek();
        rleInt.testSkips();
        TestBitFieldReader bit = new TestBitFieldReader();
        bit.testUncompressedSeek();
        bit.testCompressedSeek();
        bit.testSkips();
        TestOrcFile test1 = new TestOrcFile();
        test1.test1();
        test1.testEmptyFile();
        test1.testMetaData();
        test1.testUnionAndTimestamp();
        test1.testColumnProjection();
        test1.testSnappy();
        test1.testWithoutIndex();
        test1.testSeek();
        TestFileDump test2 = new TestFileDump();
        test2.testDump();
        test2.testDictionaryThreshold();
        test2.testUnsortedDictionary();
        TestStreamName test3 = new TestStreamName();
        test3.test1();
        TestInputOutputFormat test4 = new TestInputOutputFormat();
        test4.testInOutFormat();
        test4.testMROutput();
        test4.testEmptyFile();
        test4.testDefaultTypes();
        TestOrcStruct test5 = new TestOrcStruct();
        test5.testStruct();
        test5.testInspectorFromTypeInfo();
        test5.testUnion();
    }

    private static class TestVisitor
    implements DictionaryEncoder.Visitor<Text> {
        private final String[] words;
        private final int[] order;
        private final DataOutputBuffer buffer = new DataOutputBuffer();
        int current = 0;

        TestVisitor(String[] args, int[] order) {
            this.words = args;
            this.order = order;
        }

        public void visit(DictionaryEncoder.VisitorContext<Text> context) throws IOException {
            String word = ((Text)context.getKey()).toString();
            Assert.assertEquals((String)("in word " + this.current), (String)this.words[this.current], (String)word);
            Assert.assertEquals((String)("in word " + this.current), (int)this.order[this.current], (int)context.getOriginalPosition());
            this.buffer.reset();
            context.writeBytes((OutputStream)this.buffer);
            Assert.assertEquals((String)word, (String)new String(this.buffer.getData(), 0, this.buffer.getLength()));
            ++this.current;
        }
    }
}

