/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.airlift.log.Logger;
import com.facebook.hive.orc.OrcConf;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

class MemoryManager {
    private static final Logger LOG = Logger.get(MemoryManager.class);
    private static final int ROWS_BETWEEN_CHECKS = 5000;
    private final long totalMemoryPool;
    protected final Map<Path, WriterInfo> writerList = new HashMap<Path, WriterInfo>();
    private long totalAllocation = 0L;
    private double currentScale = 1.0;
    private int rowsAddedSinceCheck = 0;
    private boolean lowMemoryMode = false;
    private final long minAllocation;
    private final List<WriterInfo> writersForAllocation = new ArrayList<WriterInfo>();
    private final List<WriterInfo> writersForDeallocation = new ArrayList<WriterInfo>();

    MemoryManager(Configuration conf) {
        double maxLoad = OrcConf.getFloatVar(conf, OrcConf.ConfVars.HIVE_ORC_FILE_MEMORY_POOL);
        this.totalMemoryPool = Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * maxLoad);
        this.minAllocation = OrcConf.getLongVar(conf, OrcConf.ConfVars.HIVE_ORC_FILE_MIN_MEMORY_ALLOCATION);
        this.lowMemoryMode = OrcConf.getBoolVar(conf, OrcConf.ConfVars.HIVE_ORC_FILE_ENABLE_LOW_MEMORY_MODE);
    }

    synchronized void addWriter(Path path, long requestedAllocation, Callback callback, long initialAllocation) throws IOException {
        WriterInfo oldVal = this.writerList.get(path);
        if (oldVal == null) {
            oldVal = new WriterInfo(requestedAllocation, callback);
            this.writerList.put(path, oldVal);
            this.totalAllocation += requestedAllocation;
        } else {
            this.totalAllocation += requestedAllocation - oldVal.allocation;
            oldVal.allocation = requestedAllocation;
            oldVal.callback = callback;
        }
        this.updateScale(true);
        if (!this.lowMemoryMode && (double)requestedAllocation * this.currentScale <= (double)initialAllocation) {
            this.lowMemoryMode = true;
            LOG.info("ORC: Switching to low memory mode");
            for (WriterInfo writer : this.writerList.values()) {
                writer.callback.enterLowMemoryMode();
            }
        }
    }

    public boolean isLowMemoryMode() {
        return this.lowMemoryMode;
    }

    synchronized void removeWriter(Path path) throws IOException {
        WriterInfo val = this.writerList.get(path);
        if (val != null) {
            this.writerList.remove(path);
            this.totalAllocation -= val.allocation;
            this.updateScale(false);
        }
    }

    long getTotalMemoryPool() {
        return this.totalMemoryPool;
    }

    synchronized double getAllocationScale() {
        return this.currentScale;
    }

    synchronized void addedRow() throws IOException {
        if (++this.rowsAddedSinceCheck >= 5000) {
            this.notifyWriters();
        }
    }

    private void notifyWriters() throws IOException {
        LOG.debug("Notifying writers after %s", new Object[]{this.rowsAddedSinceCheck});
        for (WriterInfo writer : this.writerList.values()) {
            boolean flushed = writer.callback.checkMemory(this.currentScale * writer.allocationMultiplier);
            if (this.lowMemoryMode) {
                if (!flushed && !writer.flushedLastCheck) {
                    this.writersForDeallocation.add(writer);
                } else if (flushed && writer.flushedLastCheck) {
                    this.writersForAllocation.add(writer);
                }
                writer.flushedLastCheck = flushed;
            }
            if (!flushed) continue;
            LOG.debug("flushed %s", new Object[]{writer});
        }
        if (this.lowMemoryMode) {
            this.reallocateMemory(this.writersForAllocation, this.writersForDeallocation);
            this.writersForDeallocation.clear();
            this.writersForAllocation.clear();
        }
        this.rowsAddedSinceCheck = 0;
    }

    private void reallocateMemory(List<WriterInfo> writersForAllocation, List<WriterInfo> writersForDeallocation) {
        if (writersForDeallocation.size() > 0 && writersForAllocation.size() > 0) {
            double memoryToReallocate = 0.0;
            for (WriterInfo writer : writersForDeallocation) {
                double newAllocationMultiplier = writer.allocationMultiplier / 2.0;
                double reallocation = (double)writer.allocation * this.currentScale * newAllocationMultiplier;
                if (!(reallocation >= (double)this.minAllocation)) continue;
                writer.allocationMultiplier /= 2.0;
                memoryToReallocate += reallocation;
            }
            double memoryToReallocatePerWriter = memoryToReallocate / (double)writersForAllocation.size();
            for (WriterInfo writer : writersForAllocation) {
                writer.allocationMultiplier = ((double)writer.allocation * this.currentScale * writer.allocationMultiplier + memoryToReallocatePerWriter) / ((double)writer.allocation * this.currentScale);
            }
        }
    }

    private void updateScale(boolean isAllocate) throws IOException {
        this.currentScale = this.totalAllocation <= this.totalMemoryPool ? 1.0 : (double)this.totalMemoryPool / (double)this.totalAllocation;
    }

    public static interface Callback {
        public boolean checkMemory(double var1) throws IOException;

        public void enterLowMemoryMode() throws IOException;
    }

    protected static class WriterInfo {
        long allocation;
        Callback callback;
        boolean flushedLastCheck = true;
        double allocationMultiplier = 1.0;

        WriterInfo(long allocation, Callback callback) {
            this.allocation = allocation;
            this.callback = callback;
        }
    }
}

