/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.SerializationUtils;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class RunLengthIntegerReader {
    private final InStream input;
    private final boolean signed;
    private final int numBytes;
    private final boolean useVInts;
    private final long[] literals = new long[128];
    private int numLiterals = 0;
    private int delta = 0;
    private int used = 0;
    private boolean repeat = false;
    private int[] indeces;

    public RunLengthIntegerReader(InStream input, boolean signed, int numBytes) throws IOException {
        this.input = input;
        this.signed = signed;
        this.numBytes = numBytes;
        this.useVInts = input.useVInts();
    }

    private void readValues() throws IOException {
        int control = this.input.read();
        if (control == -1) {
            throw new EOFException("Read past end of RLE integer from " + this.input);
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new EOFException("End of stream in RLE Integer from " + this.input);
            }
            this.delta = (byte)(0 + this.delta);
            this.literals[0] = SerializationUtils.readIntegerType(this.input, this.numBytes, this.signed, this.useVInts);
        } else {
            this.repeat = false;
            this.numLiterals = 256 - control;
            this.used = 0;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = SerializationUtils.readIntegerType(this.input, this.numBytes, this.signed, this.useVInts);
            }
        }
    }

    boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    public void seek(int index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = this.indeces[index]; consumed > 0; consumed -= this.numLiterals) {
                this.readValues();
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = this.input.loadIndeces(rowIndexEntries, startIndex);
        int numIndeces = rowIndexEntries.size();
        this.indeces = new int[numIndeces + 1];
        int i = 0;
        for (OrcProto.RowIndexEntry rowIndexEntry : rowIndexEntries) {
            this.indeces[i] = (int)rowIndexEntry.getPositions(updatedStartIndex);
            ++i;
        }
        return updatedStartIndex + 1;
    }

    public void skip(long numValues) throws IOException {
        while (numValues > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(numValues, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            numValues -= consume;
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

