/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;

public class LazyFloatTreeReader
extends LazyTreeReader {
    private InStream stream;
    private float latestRead = 0.0f;

    public LazyFloatTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
        this.stream = streams.get(name);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.stream.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.stream.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    private float readFloat() throws IOException {
        this.latestRead = SerializationUtils.readFloat(this.stream);
        return this.latestRead;
    }

    FloatWritable createWritable(Object previous, float value) throws IOException {
        FloatWritable result = null;
        result = previous == null ? new FloatWritable() : (FloatWritable)previous;
        result.set(value);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public float nextFloat(boolean readStream) throws IOException, OrcLazyObject.ValueNotPresentException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize float..");
        }
        return this.readFloat();
    }

    @Override
    public Object next(Object previous) throws IOException {
        FloatWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readFloat());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        int i = 0;
        while ((long)i < numNonNullValues) {
            SerializationUtils.readFloat(this.stream);
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

