/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.lazy.LazyNumericDictionaryTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;

class LazyIntDictionaryTreeReader
extends LazyNumericDictionaryTreeReader {
    private int latestValue;

    LazyIntDictionaryTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    protected int getNumBytes() {
        return 4;
    }

    private int readInt() throws IOException {
        this.latestValue = (int)this.readPrimitive();
        return this.latestValue;
    }

    private int latestValue() {
        return this.latestValue;
    }

    IntWritable createWritable(Object previous, int v) throws IOException {
        IntWritable result = null;
        result = previous == null ? new IntWritable() : (IntWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestValue());
    }

    @Override
    public int nextInt(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestValue();
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize int.");
        }
        return this.readInt();
    }

    @Override
    public Object next(Object previous) throws IOException {
        IntWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readInt());
        }
        return result;
    }
}

