/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.lazy.LazyNumericDirectTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.io.ShortWritable;

class LazyShortDirectTreeReader
extends LazyNumericDirectTreeReader {
    private short latestRead = 0;

    LazyShortDirectTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    private short readShort() throws IOException {
        this.latestRead = (short)SerializationUtils.readIntegerType(this.input, 2, true, this.input.useVInts());
        return this.latestRead;
    }

    ShortWritable createWritable(Object previous, short v) throws IOException {
        ShortWritable result = null;
        result = previous == null ? new ShortWritable() : (ShortWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public short nextShort(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize short.");
        }
        return this.readShort();
    }

    @Override
    public Object next(Object previous) throws IOException {
        ShortWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readShort());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        int i = 0;
        while ((long)i < numNonNullValues) {
            SerializationUtils.readIntegerType(this.input, 2, true, this.input.useVInts());
            ++i;
        }
    }
}

