/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.mapreduce.output;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.output.HiveApiOutputFormat;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.record.HiveRecordFactory;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemas;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTools {
    private static final MapWritable ROW_1 = new MapWritable();
    private static final MapWritable ROW_2 = new MapWritable();
    private static final MapWritable ROW_3 = new MapWritable();
    private static final MapWritable ROW_4 = new MapWritable();
    private static final List<MapWritable> MAPPER_DATA_1 = ImmutableList.of((Object)ROW_1, (Object)ROW_2);
    private static final List<MapWritable> MAPPER_DATA_2 = ImmutableList.of((Object)ROW_3, (Object)ROW_4);
    private static final Logger LOG = LoggerFactory.getLogger(HiveTools.class);

    private HiveTools() {
    }

    public static List<MapWritable> getMapperData1() {
        return MAPPER_DATA_1;
    }

    public static List<MapWritable> getMapperData2() {
        return MAPPER_DATA_2;
    }

    private static HiveTableDesc getHiveTableName() {
        return new HiveTableDesc("default", "hive_io_test");
    }

    public static void setupJob(Configuration conf) throws IOException {
        HiveOutputDescription outputDesc = new HiveOutputDescription();
        outputDesc.setTableDesc(HiveTools.getHiveTableName());
        ImmutableMap partitionValues = ImmutableMap.of((Object)"ds", (Object)"2013-04-01");
        outputDesc.setPartitionValues((Map)partitionValues);
        LOG.info("Writing to {}", (Object)outputDesc);
        try {
            HiveApiOutputFormat.initProfile((Configuration)conf, (HiveOutputDescription)outputDesc, (String)"sample-profile");
        }
        catch (TException e) {
            LOG.error("Failed to initialize profile {}", (Object)outputDesc);
            throw new IOException(e);
        }
    }

    public static HiveWritableRecord mapToHiveRecord(Configuration conf, MapWritable value) {
        HiveTableSchema schema = HiveTableSchemas.lookup((Configuration)conf, (HiveTableDesc)HiveTools.getHiveTableName());
        HiveWritableRecord record = HiveRecordFactory.newWritableRecord((HiveTableSchema)schema);
        for (Map.Entry entry : value.entrySet()) {
            IntWritable intKey = (IntWritable)entry.getKey();
            LongWritable longValue = (LongWritable)entry.getValue();
            record.set(intKey.get(), (Object)longValue.get());
        }
        return record;
    }

    static {
        ROW_1.put((Writable)new IntWritable(0), (Writable)new LongWritable(23L));
        ROW_1.put((Writable)new IntWritable(1), (Writable)new LongWritable(34L));
        ROW_1.put((Writable)new IntWritable(2), (Writable)new LongWritable(45L));
        ROW_2.put((Writable)new IntWritable(0), (Writable)new LongWritable(11L));
        ROW_2.put((Writable)new IntWritable(1), (Writable)new LongWritable(22L));
        ROW_2.put((Writable)new IntWritable(2), (Writable)new LongWritable(33L));
        ROW_3.put((Writable)new IntWritable(0), (Writable)new LongWritable(67L));
        ROW_3.put((Writable)new IntWritable(1), (Writable)new LongWritable(78L));
        ROW_3.put((Writable)new IntWritable(2), (Writable)new LongWritable(89L));
        ROW_4.put((Writable)new IntWritable(0), (Writable)new LongWritable(99L));
        ROW_4.put((Writable)new IntWritable(1), (Writable)new LongWritable(88L));
        ROW_4.put((Writable)new IntWritable(2), (Writable)new LongWritable(77L));
    }
}

