/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.mapreduce.output;

import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.mapreduce.output.HiveTools;
import com.facebook.hiveio.mapreduce.output.SampleInputFormat;
import com.facebook.hiveio.mapreduce.output.SampleMapper;
import com.facebook.hiveio.mapreduce.output.SampleOutputFormat;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritingTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(WritingTool.class);

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        this.handleCommandLine(args, conf);
        HadoopUtils.setMapAttempts((Configuration)conf, (int)1);
        this.adjustConfigurationForHive(conf);
        HiveTools.setupJob(conf);
        Job job = new Job(conf, "hive-io-writing");
        if (job.getJar() == null) {
            job.setJarByClass(((Object)((Object)this)).getClass());
        }
        job.setMapperClass(SampleMapper.class);
        job.setInputFormatClass(SampleInputFormat.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(HiveWritableRecord.class);
        job.setOutputFormatClass(SampleOutputFormat.class);
        job.setNumReduceTasks(0);
        job.submit();
        return job.waitForCompletion(true) ? 0 : 1;
    }

    private void adjustConfigurationForHive(Configuration conf) {
        WritingTool.addToStringCollection(conf, "tmpfiles", conf.getClassLoader().getResource("hive-site.xml").toString());
        String[] hadoopJars = System.getenv("HADOOP_CLASSPATH").split(File.pathSeparator);
        ArrayList hadoopJarURLs = Lists.newArrayList();
        for (String jarPath : hadoopJars) {
            File file = new File(jarPath);
            if (!file.exists() || !file.isFile()) continue;
            String jarURL = file.toURI().toString();
            hadoopJarURLs.add(jarURL);
        }
        WritingTool.addToStringCollection(conf, "tmpjars", hadoopJarURLs);
    }

    private static void addToStringCollection(Configuration conf, String name, String ... values) {
        WritingTool.addToStringCollection(conf, name, Arrays.asList(values));
    }

    private static void addToStringCollection(Configuration conf, String name, Collection<? extends String> values) {
        Collection tmpfiles = conf.getStringCollection(name);
        tmpfiles.addAll(values);
        conf.setStrings(name, tmpfiles.toArray(new String[tmpfiles.size()]));
    }

    private void handleCommandLine(String[] args, Configuration conf) throws ParseException {
        Options options = new Options();
        options.addOption("D", "hiveconf", true, "property=value for Hive/Hadoop configuration");
        GnuParser parser = new GnuParser();
        CommandLine cmdln = parser.parse(options, args);
        this.processHiveConfOptions(cmdln, conf);
    }

    private void processHiveConfOptions(CommandLine cmdln, Configuration conf) {
        for (String hiveconf : cmdln.getOptionValues("hiveconf")) {
            String[] keyval = hiveconf.split("=", 2);
            if (keyval.length != 2) continue;
            String name = keyval[0];
            String value = keyval[1];
            if (name.equals("tmpjars") || name.equals("tmpfiles")) {
                WritingTool.addToStringCollection(conf, name, value);
                continue;
            }
            conf.set(name, value);
        }
    }
}

