/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;

public abstract class ByteArray
implements Comparable<ByteArray> {
    public static final ByteArrayComparator BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();

    public abstract byte[] getArray();

    public abstract int getLength();

    public abstract byte getAdjusted(int var1);

    public static ByteArray wrap(byte[] array) {
        return new PureByteArray(array);
    }

    public static ByteArray wrap(byte[] array, int offset) {
        return new ByteArrayView(array, offset);
    }

    public static ByteArray wrap(byte[] array, int offset, int length) {
        Preconditions.checkArgument((offset + length <= array.length ? 1 : 0) != 0);
        return new ByteArrayView(array, offset, length);
    }

    public static boolean equals(ByteArray array1, ByteArray array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.getArray() == null) {
            return array2.getArray() == null;
        }
        if (array2.getArray() == null) {
            return false;
        }
        return Arrays.equals(array1.getArray(), array2.getArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray that = (ByteArray)o;
        return ByteArray.equals(this, that);
    }

    private static class ByteArrayComparator
    implements Comparator<ByteArray> {
        private ByteArrayComparator() {
        }

        @Override
        public int compare(ByteArray o1, ByteArray o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getArray() == null) {
                if (o2.getArray() == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.getArray() == null) {
                return 1;
            }
            int array1Length = o1.getLength();
            int array2Length = o2.getLength();
            int length = Math.min(array1Length, array2Length);
            for (int i = 0; i < length; ++i) {
                if (o1.getAdjusted(i) < o2.getAdjusted(i)) {
                    return -1;
                }
                if (o1.getAdjusted(i) <= o2.getAdjusted(i)) continue;
                return 1;
            }
            if (array1Length < array2Length) {
                return -1;
            }
            if (array1Length > array2Length) {
                return 1;
            }
            return 0;
        }
    }

    private static class ByteArrayView
    extends ByteArray {
        private final byte[] array;
        private final int offset;
        private final int length;

        private ByteArrayView(byte[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        private ByteArrayView(byte[] array, int offset) {
            this(array, offset, array.length - offset);
        }

        private ByteArrayView(byte[] array) {
            this(array, 0, array.length);
        }

        @Override
        public byte[] getArray() {
            return this.array;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public byte getAdjusted(int pos) {
            return this.array[this.offset + pos];
        }

        public int hashCode() {
            int result = this.array != null ? Arrays.hashCode(this.array) : 0;
            result = 31 * result + this.offset;
            result = 31 * result + this.length;
            return result;
        }

        @Override
        public int compareTo(ByteArray o) {
            return BYTE_ARRAY_COMPARATOR.compare(this, o);
        }

        public String toString() {
            return "ByteArrayView{array=" + Arrays.toString(this.array) + ", start=" + this.offset + ", length=" + this.length + "} " + this.toString();
        }
    }

    private static class PureByteArray
    extends ByteArray {
        private final byte[] array;

        private PureByteArray(byte[] array) {
            this.array = array;
        }

        @Override
        public byte[] getArray() {
            return this.array;
        }

        @Override
        public int getLength() {
            return this.array.length;
        }

        @Override
        public byte getAdjusted(int pos) {
            return this.array[pos];
        }

        @Override
        public int compareTo(ByteArray o) {
            return BYTE_ARRAY_COMPARATOR.compare(this, o);
        }

        public int hashCode() {
            return this.array != null ? Arrays.hashCode(this.array) : 0;
        }

        public String toString() {
            return "PureByteArray{array=" + Arrays.toString(this.array) + '}';
        }
    }
}

