/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.facebook.collections.TranslatingIterator;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CounterMap<K>
implements Iterable<Map.Entry<K, Long>> {
    private static final ValueComparableAtomicLong ZERO = new ValueComparableAtomicLong(0L);
    private final ConcurrentMap<K, ValueComparableAtomicLong> counters = new ConcurrentHashMap<K, ValueComparableAtomicLong>();
    private final ReadWriteLock removalLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGet(K key, long delta) {
        long retVal;
        this.removalLock.readLock().lock();
        try {
            retVal = this.getCounter(key).addAndGet(delta);
        }
        finally {
            this.removalLock.readLock().unlock();
        }
        if (retVal == 0L) {
            this.tryCleanup(key);
        }
        return retVal;
    }

    public long size() {
        return this.counters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndAdd(K key, long delta) {
        long retVal;
        this.removalLock.readLock().lock();
        try {
            retVal = this.getCounter(key).getAndAdd(delta);
        }
        finally {
            this.removalLock.readLock().unlock();
        }
        if (retVal + delta == 0L) {
            this.tryCleanup(key);
        }
        return retVal;
    }

    private ValueComparableAtomicLong getCounter(K key) {
        ValueComparableAtomicLong counter = (ValueComparableAtomicLong)this.counters.get(key);
        if (counter == null) {
            ValueComparableAtomicLong newCounter = new ValueComparableAtomicLong(0L);
            ValueComparableAtomicLong oldCounter = this.counters.putIfAbsent(key, newCounter);
            counter = oldCounter == null ? newCounter : oldCounter;
        }
        return counter;
    }

    private void tryCleanup(K key) {
        this.removalLock.writeLock().lock();
        try {
            this.counters.remove(key, ZERO);
        }
        finally {
            this.removalLock.writeLock().unlock();
        }
    }

    public AtomicLong remove(K key) {
        ValueComparableAtomicLong removedCounter = (ValueComparableAtomicLong)this.counters.remove(key);
        return removedCounter == null ? null : removedCounter.getValue();
    }

    public long get(K key) {
        ValueComparableAtomicLong counter = (ValueComparableAtomicLong)this.counters.get(key);
        if (counter == null) {
            return 0L;
        }
        return counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryInitializeCounter(K key, long value) {
        this.removalLock.readLock().lock();
        try {
            ValueComparableAtomicLong counter = this.getCounter(key);
            counter.compareAndSet(0L, value);
            long l = counter.get();
            return l;
        }
        finally {
            this.removalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long trySetCounter(K key, long value) {
        this.removalLock.readLock().lock();
        try {
            ValueComparableAtomicLong counter = this.getCounter(key);
            counter.compareAndSet(counter.get(), value);
            long l = counter.get();
            return l;
        }
        finally {
            this.removalLock.readLock().unlock();
        }
    }

    public void clear() {
        this.removalLock.writeLock().lock();
        try {
            this.counters.clear();
        }
        finally {
            this.removalLock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, Long>> iterator() {
        return Iterators.unmodifiableIterator(new TranslatingIterator(input -> new AbstractMap.SimpleImmutableEntry(input.getKey(), ((ValueComparableAtomicLong)input.getValue()).get()), this.counters.entrySet().iterator()));
    }

    private static class ValueComparableAtomicLong {
        private final AtomicLong value;

        private ValueComparableAtomicLong(AtomicLong value) {
            this.value = value;
        }

        private ValueComparableAtomicLong(long value) {
            this(new AtomicLong(value));
        }

        private AtomicLong getValue() {
            return this.value;
        }

        private long get() {
            return this.value.get();
        }

        private long addAndGet(long delta) {
            return this.value.addAndGet(delta);
        }

        private long getAndAdd(long delta) {
            return this.value.getAndAdd(delta);
        }

        public boolean compareAndSet(long expect, long update) {
            return this.value.compareAndSet(expect, update);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueComparableAtomicLong that = (ValueComparableAtomicLong)o;
            return this.value.get() == that.value.get();
        }

        public int hashCode() {
            return Long.hashCode(this.value.get());
        }
    }
}

