/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class PeekableIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> delegate;
    private T value = null;

    public PeekableIterator(Iterator<? extends T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() || this.value != null;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.value == null) {
            this.internalNext();
        }
        T retVal = this.value;
        this.value = null;
        return retVal;
    }

    private void internalNext() throws NoSuchElementException {
        this.value = this.delegate.next();
    }

    public T peekNext() {
        if (this.value == null) {
            this.internalNext();
        }
        return this.value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

