/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.facebook.collections.SimpleHeap;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;

public class PriorityQueueHeap<T>
implements SimpleHeap<T> {
    private volatile PriorityQueue<T> priorityQueue;

    public PriorityQueueHeap(PriorityQueue<T> priorityQueue) {
        this.priorityQueue = priorityQueue;
    }

    @Override
    public T peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public T poll() {
        return this.priorityQueue.poll();
    }

    @Override
    public boolean add(T item) {
        return this.priorityQueue.add(item);
    }

    @Override
    public boolean addAll(Collection<? extends T> items) {
        return this.priorityQueue.addAll(items);
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }

    @Override
    public int shrink() {
        PriorityQueue<T> newPriorityQueue = new PriorityQueue<T>(this.priorityQueue);
        this.priorityQueue = newPriorityQueue;
        return 0;
    }

    @Override
    public SimpleHeap<T> makeCopy() {
        return new PriorityQueueHeap<T>(new PriorityQueue<T>(this.priorityQueue));
    }

    @Override
    public Iterator<T> iterator() {
        return this.priorityQueue.iterator();
    }
}

