/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class RangeSet
extends AbstractSet<Long>
implements Set<Long> {
    private final NavigableMap<Long, LongSegment> map = new TreeMap<Long, LongSegment>();
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        Long value = ((Number)o).longValue();
        Map.Entry<Long, LongSegment> entry = this.map.floorEntry(value);
        return entry != null && entry.getValue().contains(value);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private final Iterator<LongSegment> segmentIterator;
            private Iterator<Long> longIterator;
            {
                this.segmentIterator = RangeSet.this.map.values().iterator();
                this.longIterator = this.segmentIterator.hasNext() ? this.segmentIterator.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                return this.longIterator != null && this.longIterator.hasNext();
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Long ret = this.longIterator.next();
                if (!this.longIterator.hasNext()) {
                    this.longIterator = this.segmentIterator.hasNext() ? this.segmentIterator.next().iterator() : null;
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator does not support remove");
            }
        };
    }

    @Override
    public boolean add(Long aLong) {
        boolean upperAdjacent;
        Map.Entry<Long, LongSegment> lowerEntry = this.map.floorEntry(aLong);
        if (lowerEntry != null && lowerEntry.getValue().contains(aLong)) {
            return false;
        }
        LongSegment upperSegment = (LongSegment)this.map.get(aLong + 1L);
        boolean lowerAdjacent = lowerEntry != null && lowerEntry.getValue().getMax() + 1L == aLong;
        boolean bl = upperAdjacent = upperSegment != null && upperSegment.getMin() - 1L == aLong;
        if (lowerAdjacent && upperAdjacent) {
            this.map.put(lowerEntry.getValue().getMin(), new LongSegment(lowerEntry.getValue().getMin(), upperSegment.getMax()));
            this.map.remove(upperSegment.getMin());
        } else if (lowerAdjacent) {
            this.map.put(lowerEntry.getValue().getMin(), new LongSegment(lowerEntry.getValue().getMin(), aLong));
        } else if (upperAdjacent) {
            this.map.put(aLong, new LongSegment(aLong, upperSegment.getMax()));
            this.map.remove(upperSegment.getMin());
        } else {
            this.map.put(aLong, new LongSegment((long)aLong));
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Long value = ((Number)o).longValue();
        Map.Entry<Long, LongSegment> entry = this.map.floorEntry(value);
        if (entry == null) {
            return false;
        }
        if (!entry.getValue().contains(value)) {
            return false;
        }
        if (entry.getValue().getMin() < value) {
            this.map.put(entry.getValue().getMin(), new LongSegment(entry.getValue().getMin(), value - 1L));
        } else {
            this.map.remove(entry.getValue().getMin());
        }
        if (entry.getValue().getMax() > value) {
            this.map.put(value + 1L, new LongSegment(value + 1L, entry.getValue().getMax()));
        }
        --this.size;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    private static class LongSegment
    implements Iterable<Long> {
        private final long min;
        private final long max;

        private LongSegment(long min, long max) {
            this.min = min;
            this.max = max;
            if (max < min) {
                throw new IllegalArgumentException();
            }
        }

        private LongSegment(long value) {
            this(value, value);
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public boolean contains(long value) {
            return value >= this.min && value <= this.max;
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private long currentValue;
                {
                    this.currentValue = min;
                }

                @Override
                public boolean hasNext() {
                    return this.currentValue <= max;
                }

                @Override
                public Long next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    long ret = this.currentValue++;
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Iterator does not support remove");
                }
            };
        }
    }
}

