/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.facebook.collections.SetFactory;
import com.facebook.collections.SetMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SetMapImpl<K, V, S extends Set<V>>
implements SetMap<K, V, S> {
    private final ConcurrentMap<K, S> sets = new ConcurrentHashMap<K, S>();
    private final ReadWriteLock removalLock = new ReentrantReadWriteLock();
    private final SetFactory<V, S> setFactory;

    public SetMapImpl(SetFactory<V, S> setFactory) {
        this.setFactory = setFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(K key, V item) {
        this.removalLock.readLock().lock();
        try {
            Set existingSet;
            Set<Object> set = (Set)this.sets.get(key);
            if (set == null && (existingSet = this.sets.putIfAbsent(key, set = this.setFactory.create())) != null) {
                set = existingSet;
            }
            boolean bl = set.add(item);
            return bl;
        }
        finally {
            this.removalLock.readLock().unlock();
        }
    }

    @Override
    public S removeSet(K key) {
        return (S)((Set)this.sets.remove(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V item) {
        Set set = (Set)this.sets.get(key);
        if (set == null) {
            return false;
        }
        boolean removed = set.remove(item);
        if (set.isEmpty()) {
            this.removalLock.writeLock().lock();
            try {
                this.sets.remove(key, Collections.EMPTY_SET);
            }
            finally {
                this.removalLock.writeLock().unlock();
            }
        }
        return removed;
    }

    @Override
    public S get(K key) {
        return (S)((Set)this.sets.get(key));
    }

    @Override
    public void clear() {
        this.sets.clear();
    }

    @Override
    public Iterator<Map.Entry<K, S>> iterator() {
        return this.sets.entrySet().iterator();
    }
}

