/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.OpenLongObjectHashMap;
import com.facebook.collections.SetFactory;
import com.facebook.collections.specialized.ColtIntegerHashSet;
import com.facebook.collections.specialized.ColtLongHashSet;
import com.facebook.collections.specialized.NumberType;
import com.facebook.collections.specialized.SnapshotableSet;

public class ColtHashSetFactory
implements SetFactory<Long, SnapshotableSet<Long>> {
    private static final int DEFAULT_INITIAL_VALUE = 3;
    private static final double DEFAULT_MIN_LOAD_FACTOR = 0.7;
    private static final double DEFAULT_MAX_LOAD_FACTOR = 0.9;
    private final NumberType numberType;
    private final int initialValue;
    private final double minLoadFactor;
    private final double maxLoadFactor;

    public ColtHashSetFactory(NumberType numberType, int initialValue, double maxLoadFactor, double minLoadFactor) {
        this.numberType = numberType;
        this.initialValue = initialValue;
        this.maxLoadFactor = maxLoadFactor;
        this.minLoadFactor = minLoadFactor;
    }

    public ColtHashSetFactory(NumberType numberType, int initialValue) {
        this(numberType, initialValue, 0.7, 0.9);
    }

    @Override
    public SnapshotableSet<Long> create() {
        if (this.numberType == NumberType.INTEGER) {
            return new ColtIntegerHashSet(new OpenIntObjectHashMap(this.initialValue, this.minLoadFactor, this.maxLoadFactor));
        }
        if (this.numberType == NumberType.LONG) {
            return new ColtLongHashSet(new OpenLongObjectHashMap(this.initialValue, this.minLoadFactor, this.maxLoadFactor));
        }
        throw new IllegalStateException(String.format("unknown type %s", new Object[]{this.numberType}));
    }
}

