/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.Trackable;
import com.facebook.collections.specialized.SnapshotableSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import gnu.trove.TIntCollection;
import gnu.trove.impl.sync.TSynchronizedIntSet;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class IntegerHashSet
implements SnapshotableSet<Long>,
Trackable {
    private static final float MAX_LOAD_FACTOR = 0.6666667f;
    private final TIntSet set;
    private final Object mutex = new Object();
    private final int maxCapacity;
    @GuardedBy(value="mutex")
    private volatile boolean hasChanged;

    public IntegerHashSet(int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (String)"initial capacity of %s cannot be larger than max of %s", (Object[])new Object[]{initialCapacity, maxCapacity});
        this.set = new TSynchronizedIntSet((TIntSet)new TIntHashSet(initialCapacity, 0.6666667f, -1), this.mutex);
        this.maxCapacity = maxCapacity;
    }

    public IntegerHashSet(int maxCapacity) {
        this(Math.max(maxCapacity / 16, 1), maxCapacity);
    }

    private IntegerHashSet(IntegerHashSet set) {
        this.set = new TSynchronizedIntSet((TIntSet)new TIntHashSet((TIntCollection)set.set), this.mutex);
        this.maxCapacity = set.maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object value) {
        if (value instanceof Integer || value instanceof Long) {
            Object object = this.mutex;
            synchronized (object) {
                return this.set.contains(((Number)value).intValue());
            }
        }
        return false;
    }

    @Override
    @VisibleForTesting
    boolean add(Integer value) {
        return this.add(value.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Long value) {
        Object object = this.mutex;
        synchronized (object) {
            Preconditions.checkState((this.set.size() < this.maxCapacity ? 1 : 0) != 0, (String)"set is size %s which means we're full, but someone's calling add. Why?", (Object[])new Object[]{this.set.size()});
            if (this.set.add(value.intValue())) {
                this.hasChanged = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        if (value instanceof Integer || value instanceof Long) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.set.remove(((Number)value).intValue())) {
                    this.hasChanged = true;
                }
            }
        }
        return this.hasChanged;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Long> iterator() {
        Object object = this.mutex;
        synchronized (object) {
            return new Iterator<Long>(){
                private TIntIterator iterator;
                {
                    this.iterator = IntegerHashSet.this.set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Long next() throws NoSuchElementException {
                    return this.iterator.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void remove() {
                    Object object = IntegerHashSet.this.mutex;
                    synchronized (object) {
                        this.iterator.remove();
                        IntegerHashSet.this.hasChanged = true;
                    }
                }
            };
        }
    }

    @Override
    public Object[] toArray() {
        int[] ints = this.set.toArray();
        Object[] result = new Object[ints.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] result) {
        int[] ints = this.set.toArray();
        if (result.length < ints.length) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), ints.length);
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        return this.set.containsAll(values);
    }

    @Override
    public boolean addAll(Collection<? extends Long> values) {
        boolean retVal = false;
        for (Long l : values) {
            Preconditions.checkState((this.set.size() < this.maxCapacity ? 1 : 0) != 0, (String)"set is size %s which means we're full, but someone's calling add. Why?", (Object[])new Object[]{this.set.size()});
            retVal |= this.set.add(l.intValue());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> values) {
        boolean methodHasChanged;
        Object object = this.mutex;
        synchronized (object) {
            methodHasChanged = this.set.retainAll(values);
            this.hasChanged |= methodHasChanged;
        }
        return methodHasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> values) {
        boolean methodHasChanged;
        Object object = this.mutex;
        synchronized (object) {
            methodHasChanged = this.set.removeAll(values);
            this.hasChanged |= methodHasChanged;
        }
        return methodHasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.set.isEmpty()) {
                this.set.clear();
                this.hasChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotableSet<Long> makeSnapshot() {
        Object object = this.mutex;
        synchronized (object) {
            return new IntegerHashSet(this);
        }
    }

    @Override
    public SnapshotableSet<Long> makeTransientSnapshot() {
        return this.makeSnapshot();
    }

    @Override
    public boolean hasChanged() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl;
            try {
                bl = this.hasChanged;
                this.hasChanged = false;
            }
            catch (Throwable throwable) {
                this.hasChanged = false;
                throw throwable;
            }
            return bl;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntegerHashSet) {
            IntegerHashSet integerHashSet = (IntegerHashSet)o;
            return !(this.set == null ? integerHashSet.set != null : !this.set.equals((Object)integerHashSet.set));
        }
        if (o instanceof Set) {
            Set otherSet = (Set)o;
            return this.set != null && this.set.size() == otherSet.size() && this.containsAll(otherSet);
        }
        return this.set == null && o == null;
    }

    @Override
    public int hashCode() {
        int result = this.set != null ? this.set.hashCode() : 0;
        result = 31 * result + (this.mutex != null ? this.mutex.hashCode() : 0);
        result = 31 * result + (this.hasChanged ? 1 : 0);
        return result;
    }
}

