/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.SetFactory;
import com.facebook.collections.specialized.IntegerHashSet;
import com.facebook.collections.specialized.SnapshotableSet;

public class IntegerHashSetFactory
implements SetFactory<Long, SnapshotableSet<Long>> {
    public static final int DEFAULT_MAX_SIZE = 8000;
    public static final int DEFAULT_INITIAL_SIZE = 4;
    private final int initialCapacity;
    private final int maxCapacity;

    public IntegerHashSetFactory(int initialCapacity, int maxCapacity) {
        this.initialCapacity = initialCapacity;
        this.maxCapacity = maxCapacity;
    }

    public IntegerHashSetFactory(int maxCapacity) {
        this(4, maxCapacity);
    }

    public IntegerHashSetFactory() {
        this(4, 8000);
    }

    public static IntegerHashSetFactory withInitialSize(int initialSize) {
        return new IntegerHashSetFactory(initialSize, 8000);
    }

    public static IntegerHashSetFactory withMaxSize(int maxSize) {
        return new IntegerHashSetFactory(4, maxSize);
    }

    @Override
    public SnapshotableSet<Long> create() {
        return new IntegerHashSet(this.initialCapacity, 2 * this.maxCapacity);
    }
}

