/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.Trackable;
import com.facebook.collections.specialized.HashSetFactory;
import com.facebook.collections.specialized.SnapshotableSet;
import com.facebook.collections.specialized.SnapshotableSetImpl;
import com.facebook.collections.specialized.SnapshotableSetImplFactory;
import com.facebook.collectionsbase.Mapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;

public class LongHashSet
implements SnapshotableSet<Long>,
Trackable {
    private static final long INITIAL_EMPTY = -1L;
    private static final long REMOVED_EMPTY = -2L;
    private static final int FULL_SET = -3;
    private static final float MIN_LOAD_FACTOR = 0.6666667f;
    private static final float MAX_LOAD_FACTOR = 0.9f;
    private final Mapper<Long, Integer> hashFunction;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicLong version = new AtomicLong(0L);
    private long lastCheckedVersion = 0L;
    @GuardedBy(value="lock")
    private volatile long[] values;
    private AtomicInteger size = new AtomicInteger(0);
    private final int maxCapacity;

    public LongHashSet(int initialCapacity, int maxCapacity, Mapper<Long, Integer> hashFunction) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (String)"initial capacity of %s cannot be larger than max of %s", (Object[])new Object[]{initialCapacity, maxCapacity});
        this.maxCapacity = maxCapacity;
        this.initArrays(initialCapacity);
        this.hashFunction = hashFunction;
    }

    private void initArrays(int capacity) {
        this.values = new long[capacity];
        Arrays.fill(this.values, -1L);
    }

    public LongHashSet(int initialCapacity, int maxCapacity) {
        this(initialCapacity, maxCapacity, new Mapper<Long, Integer>(){

            public Integer map(Long input) {
                return (int)(input ^ input >>> 32);
            }
        });
    }

    private void resize() {
        if (this.values.length == this.maxCapacity) {
            throw new IllegalStateException(String.format("cannot resize: max capacity of %d already reached", this.maxCapacity));
        }
        int desiredSize = (int)((float)this.values.length / 0.6666667f);
        int newSize = Math.min(desiredSize, this.maxCapacity);
        long[] oldValues = this.values;
        this.values = new long[newSize];
        this.internalClear();
        for (long value : oldValues) {
            if (value < 0L) continue;
            this.internalAdd(value);
        }
    }

    private int hashValueOf(Long aLong) {
        return Math.abs((Integer)this.hashFunction.map((Object)aLong)) % this.values.length;
    }

    private int findLocationOf(long aLong) {
        int index = this.hashValueOf(aLong);
        int firstEmptyIndex = -1;
        int total = 0;
        while (this.values[index] != aLong) {
            if (this.values[index] == -1L) {
                return index;
            }
            if (this.isEmptySlot(index) && firstEmptyIndex == -1) {
                firstEmptyIndex = index;
            }
            if (++total == this.values.length) {
                if (firstEmptyIndex == -1) {
                    return -3;
                }
                return firstEmptyIndex;
            }
            index = (index + 1) % this.values.length;
        }
        return index;
    }

    private boolean isEmptySlot(int index) {
        return this.values[index] < 0L;
    }

    private void validateArgument(Long aLong) {
        if (aLong < 0L) {
            throw new IllegalArgumentException(String.format("only non-negative integers are allowed (tried to use %d)", aLong));
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Long)) {
            throw new IllegalArgumentException("type of long required");
        }
        this.lock.readLock().lock();
        try {
            int index = this.findLocationOf((Long)o);
            boolean bl = index != -3 && !this.isEmptySlot(index);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<Long> iterator() {
        final AtomicLong snapshotVersion = new AtomicLong(this.version.get());
        final long sizeSnapshot = this.size.get();
        return new Iterator<Long>(){
            private int location = -1;
            private int visited = 0;
            private boolean canRemove = false;

            @Override
            public boolean hasNext() {
                LongHashSet.this.lock.readLock().lock();
                try {
                    if (LongHashSet.this.version.get() != snapshotVersion.get()) {
                        throw new ConcurrentModificationException();
                    }
                    boolean bl = (long)this.visited < sizeSnapshot;
                    return bl;
                }
                finally {
                    LongHashSet.this.lock.readLock().unlock();
                }
            }

            @Override
            public Long next() {
                LongHashSet.this.lock.readLock().lock();
                try {
                    if (LongHashSet.this.version.get() != snapshotVersion.get()) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.location >= LongHashSet.this.values.length) {
                        throw new NoSuchElementException();
                    }
                    do {
                        ++this.location;
                        if (this.location < LongHashSet.this.values.length) continue;
                        throw new NoSuchElementException();
                    } while (LongHashSet.this.isEmptySlot(this.location));
                    ++this.visited;
                    this.canRemove = true;
                    Long l = LongHashSet.this.values[this.location];
                    return l;
                }
                finally {
                    LongHashSet.this.lock.readLock().unlock();
                }
            }

            @Override
            public void remove() {
                LongHashSet.this.lock.writeLock().lock();
                try {
                    if (!this.canRemove) {
                        throw new IllegalStateException("repeated remove() calls or next() not called");
                    }
                    if (LongHashSet.this.version.get() != snapshotVersion.get()) {
                        throw new ConcurrentModificationException();
                    }
                    ((LongHashSet)LongHashSet.this).values[this.location] = -2L;
                    LongHashSet.this.size.decrementAndGet();
                    snapshotVersion.set(LongHashSet.this.version.incrementAndGet());
                    this.canRemove = false;
                }
                finally {
                    LongHashSet.this.lock.writeLock().unlock();
                }
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size.get()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object[] result;
        if (!a.getClass().getComponentType().isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("array must be of type Long");
        }
        this.lock.readLock().lock();
        try {
            result = a.length >= this.size.get() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size.get());
            int i = 0;
            for (Long value : this) {
                result[i++] = value;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    @Override
    @VisibleForTesting
    boolean add(Integer anInteger) {
        return this.add(anInteger.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Long aLong) {
        this.validateArgument(aLong);
        this.lock.writeLock().lock();
        try {
            int maxUsedBuckets = (int)(0.9f * (float)this.values.length);
            if (this.size.get() > maxUsedBuckets && this.values.length < this.maxCapacity) {
                this.resize();
            }
            if (this.internalAdd(aLong)) {
                this.version.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean internalAdd(long value) {
        int index = this.findLocationOf(value);
        if (index == -3) {
            throw new IllegalStateException(String.format("set is full with %d elements, cannot add more", this.values.length));
        }
        if (this.isEmptySlot(index)) {
            this.values[index] = value;
            this.size.incrementAndGet();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Long)) {
            throw new IllegalArgumentException("type of long required");
        }
        this.validateArgument((Long)o);
        this.lock.writeLock().lock();
        try {
            int index = this.findLocationOf((Long)o);
            if (index != -3 && !this.isEmptySlot(index)) {
                this.values[index] = -2L;
                this.version.incrementAndGet();
                this.size.decrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.lock.readLock().lock();
        try {
            for (Object element : c) {
                if (this.contains(element)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        boolean changed = false;
        for (Long l : c) {
            if (!this.add(l)) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            Iterator<Long> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (c.contains(iterator.next())) continue;
                iterator.remove();
                this.size.decrementAndGet();
                changed = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            Iterator<Object> i;
            if (this.size() > c.size()) {
                i = c.iterator();
                while (i.hasNext()) {
                    changed |= this.remove(i.next());
                }
            } else {
                i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    changed = true;
                }
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.internalClear();
            this.version.incrementAndGet();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public SnapshotableSet<Long> makeSnapshot() {
        this.lock.readLock().lock();
        try {
            LongHashSet copy = new LongHashSet(this.values.length, this.maxCapacity, this.hashFunction);
            copy.size.set(this.size.get());
            System.arraycopy(this.values, 0, copy.values, 0, this.values.length);
            LongHashSet longHashSet = copy;
            return longHashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public SnapshotableSet<Long> makeTransientSnapshot() {
        return new SnapshotableSetImpl<Long>(Collections.synchronizedSet(new HashSet<Long>(this)), new SnapshotableSetImplFactory(new HashSetFactory()));
    }

    private void internalClear() {
        this.size.set(0);
        Arrays.fill(this.values, -1L);
    }

    @Override
    public synchronized boolean hasChanged() {
        long pastVersion = this.lastCheckedVersion;
        this.lastCheckedVersion = this.version.get();
        return this.lastCheckedVersion != pastVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Long value : this) {
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size.get() * 8);
        Object copy = this.makeSnapshot();
        boolean first = true;
        sb.append("{");
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            Long value = (Long)iterator.next();
            if (!first) {
                sb.append(", ");
            }
            sb.append(value);
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }
}

