/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.SetFactory;
import com.facebook.collections.specialized.LongHashSet;
import com.facebook.collections.specialized.SnapshotableSet;

public class LongHashSetFactory
implements SetFactory<Long, SnapshotableSet<Long>> {
    public static final int DEFAULT_INITIAL_SIZE = 4;
    public static final int DEFAULT_MAX_SIZE = 8000;
    private final int initialSize;
    private final int maxSetSize;

    public LongHashSetFactory(int initialSize, int maxSetSize) {
        this.initialSize = initialSize;
        this.maxSetSize = maxSetSize;
    }

    public LongHashSetFactory(int maxSetSize) {
        this(4, maxSetSize);
    }

    public static LongHashSetFactory withInitialSize(int initialSize) {
        return new LongHashSetFactory(initialSize, 8000);
    }

    public static LongHashSetFactory withMaxSize(int maxSize) {
        return new LongHashSetFactory(4, maxSize);
    }

    @Override
    public SnapshotableSet<Long> create() {
        return new LongHashSet(this.initialSize, (int)(1.2f * (float)this.maxSetSize));
    }
}

