/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.SimpleHeapFactory;
import com.facebook.collections.specialized.LongPairList;
import com.facebook.collections.specialized.LongTripleList;
import com.facebook.collections.specialized.LongTupleHeap;

public class LongTupleHeapFactory
implements SimpleHeapFactory<long[], LongTupleHeap> {
    private final int tupleSize;

    public LongTupleHeapFactory(int tupleSize) {
        this.tupleSize = tupleSize;
    }

    @Override
    public LongTupleHeap create(int initializeSize) {
        if (this.tupleSize == 2) {
            return new LongPairList(initializeSize);
        }
        if (this.tupleSize == 3) {
            return new LongTripleList(initializeSize);
        }
        throw new IllegalStateException(String.format("tuple size of %d attempted. Only 2 and 3 supported", this.tupleSize));
    }
}

