/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.SetFactory;
import com.facebook.collections.WrappedIterator;
import com.facebook.collections.specialized.HashSetFactory;
import com.facebook.collections.specialized.SampledSet;
import com.facebook.collections.specialized.SampledSetSnapshot;
import com.facebook.collections.specialized.SnapshotableSet;
import com.facebook.collections.specialized.SnapshotableSetImplFactory;
import com.facebook.util.digest.DigestFunction;
import com.facebook.util.serialization.SerDe;
import com.facebook.util.serialization.SerDeException;
import com.google.common.collect.ImmutableSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SampledSetImpl<T>
implements SampledSet<T> {
    private final DigestFunction<T> digestFunction;
    private final SetFactory<T, SnapshotableSet<T>> setFactory;
    private final int maxSetSize;
    private final AtomicInteger proposedSize = new AtomicInteger(0);
    private final ReadWriteLock downSampleLock = new ReentrantReadWriteLock();
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private volatile SnapshotableSet<T> baseSet;
    private volatile int currentSampleRate;

    @Deprecated
    public SampledSetImpl(int maxSetSize, DigestFunction<T> digestFunction, SnapshotableSet<T> baseSet, SetFactory<T, SnapshotableSet<T>> setFactory, int currentSampleRate) {
        this.maxSetSize = maxSetSize;
        this.digestFunction = digestFunction;
        this.setFactory = setFactory;
        this.baseSet = baseSet;
        this.currentSampleRate = currentSampleRate;
        this.proposedSize.set(baseSet.size());
    }

    public SampledSetImpl(int maxSetSize, DigestFunction<T> digestFunction, SetFactory<T, SnapshotableSet<T>> setFactory) {
        this(maxSetSize, digestFunction, setFactory.create(), setFactory, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean add(T element) {
        returnValue = false;
        elementDigest = this.digestFunction.computeDigest(element);
        if (this.inSample(elementDigest, sampleRateSnapshot = this.currentSampleRate)) {
            if (this.proposedSize.incrementAndGet() > this.maxSetSize) {
                this.downSampleLock.writeLock().lock();
                try {
                    if (!this.inSample(elementDigest, this.currentSampleRate) || this.baseSet.contains(element)) ** GOTO lbl29
                    this.downSample();
                    if (!this.inSample(elementDigest, this.currentSampleRate)) ** GOTO lbl29
                    returnValue = this.baseSet.add(element);
                }
                finally {
                    if (!returnValue) {
                        this.proposedSize.decrementAndGet();
                    }
                    this.downSampleLock.writeLock().unlock();
                }
            } else {
                this.downSampleLock.readLock().lock();
                try {
                    if (this.currentSampleRate == sampleRateSnapshot || this.inSample(elementDigest, this.currentSampleRate)) {
                        returnValue = this.baseSet.add(element);
                    }
                }
                finally {
                    if (!returnValue) {
                        this.proposedSize.decrementAndGet();
                    }
                    this.downSampleLock.readLock().unlock();
                }
            }
        }
        if (returnValue) {
            this.dirty.set(true);
        }
        return returnValue;
    }

    private boolean inSample(long digest, int sampleRate) {
        return digest % (long)sampleRate == 0L;
    }

    private void downSample() {
        int removed = 0;
        while (this.baseSet.size() >= this.maxSetSize) {
            this.currentSampleRate <<= 1;
            assert (this.currentSampleRate > 1);
            removed += this.downSampleAtRate(this.currentSampleRate, this.baseSet);
        }
        if (removed > 0) {
            this.proposedSize.addAndGet(-removed);
        }
    }

    private int downSampleAtRate(int sampleRate, Set<T> set) {
        int removed = 0;
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (this.inSample(this.digestFunction.computeDigest(value), sampleRate)) continue;
            iterator.remove();
            ++removed;
        }
        return removed;
    }

    private SnapshotableSet<T> copyAtRate(int sampleRate) {
        if (sampleRate <= this.currentSampleRate) {
            return (SnapshotableSet)this.baseSet.makeSnapshot();
        }
        SnapshotableSet target = (SnapshotableSet)this.baseSet.makeSnapshot();
        this.downSampleAtRate(sampleRate, target);
        return target;
    }

    @Override
    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    @Override
    public int getScaledSize() {
        return this.baseSet.size() * this.currentSampleRate;
    }

    @Override
    public int getSampleRate() {
        return this.currentSampleRate;
    }

    @Override
    public int getSize() {
        return this.baseSet.size();
    }

    @Override
    public Set<T> getEntries() {
        return ImmutableSet.copyOf(this.baseSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampledSetSnapshot<T> sampleAt(int rate) {
        SnapshotableSet<T> setCopy;
        int setCopySampleRate;
        this.downSampleLock.readLock().lock();
        try {
            setCopySampleRate = Math.max(rate, this.currentSampleRate);
            setCopy = this.copyAtRate(setCopySampleRate);
        }
        finally {
            this.downSampleLock.readLock().unlock();
        }
        return new SampledSetSnapshot<T>(setCopySampleRate, this.maxSetSize, setCopy);
    }

    @Override
    public SampledSet<T> merge(SampledSet<T> sampledSet) {
        Object mergedSampleSet = this.makeSnapshot();
        mergedSampleSet.mergeInPlaceWith(sampledSet);
        mergedSampleSet.hasChanged();
        return mergedSampleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mergeInPlaceWith(SampledSet<T> sampledSet) {
        boolean changed = false;
        SampledSetSnapshot<T> snapshot = sampledSet.sampleAt(this.currentSampleRate);
        this.downSampleLock.writeLock().lock();
        try {
            if (this.currentSampleRate <= snapshot.getSampleRate() && this.baseSet.isEmpty() && this.maxSetSize >= snapshot.getElements().size()) {
                this.baseSet = snapshot.getElements();
                this.currentSampleRate = snapshot.getSampleRate();
                this.proposedSize.set(this.baseSet.size());
                this.dirty.set(true);
                boolean bl = true;
                return bl;
            }
            if (!snapshot.getElements().isEmpty() && snapshot.getSampleRate() > this.currentSampleRate) {
                int removed = this.downSampleAtRate(snapshot.getSampleRate(), this.baseSet);
                if (removed > 0) {
                    changed = true;
                    this.proposedSize.addAndGet(-removed);
                }
                this.currentSampleRate = snapshot.getSampleRate();
            }
        }
        finally {
            this.downSampleLock.writeLock().unlock();
        }
        for (Object element : snapshot.getElements()) {
            if (!this.add((T)element)) continue;
            changed = true;
        }
        if (changed) {
            this.dirty.set(true);
        }
        return changed;
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.getAndSet(false);
    }

    @Override
    public Iterator<T> iterator() {
        return new WrappedIterator<T>(this.baseSet.iterator()){

            @Override
            public void remove() {
                super.remove();
                SampledSetImpl.this.dirty.set(true);
            }
        };
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.baseSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.baseSet.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.baseSet.toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.baseSet.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        if (this.baseSet.remove(o)) {
            this.dirty.set(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.baseSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = false;
        for (T item : c) {
            if (!this.add(item)) continue;
            added = true;
        }
        if (added) {
            this.dirty.set(true);
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.baseSet.retainAll(c)) {
            this.dirty.set(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.baseSet.removeAll(c)) {
            this.dirty.set(true);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.baseSet.clear();
        this.dirty.set(true);
    }

    @Override
    public SampledSet<T> makeSnapshot() {
        return new SampledSetImpl<T>(this.maxSetSize, this.digestFunction, (SnapshotableSet)this.baseSet.makeSnapshot(), this.setFactory, this.currentSampleRate);
    }

    @Override
    public SampledSet<T> makeTransientSnapshot() {
        SnapshotableSetImplFactory cpuEfficientHashSetFactory = new SnapshotableSetImplFactory(new HashSetFactory());
        SnapshotableSet cpuEfficientHashSet = (SnapshotableSet)this.baseSet.makeTransientSnapshot();
        return new SampledSetImpl<T>(this.maxSetSize, this.digestFunction, cpuEfficientHashSet, cpuEfficientHashSetFactory, this.currentSampleRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        this.downSampleLock.writeLock().lock();
        try {
            if (this == o) {
                boolean bl = true;
                return bl;
            }
            if (o == null || this.getClass() != o.getClass()) {
                boolean bl = false;
                return bl;
            }
            SampledSetImpl that = (SampledSetImpl)o;
            if (this.currentSampleRate != that.currentSampleRate) {
                boolean bl = false;
                return bl;
            }
            if (this.maxSetSize != that.maxSetSize) {
                boolean bl = false;
                return bl;
            }
            if (this.baseSet != null ? !this.baseSet.equals(that.baseSet) : that.baseSet != null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.downSampleLock.writeLock().unlock();
        }
    }

    @Override
    public int hashCode() {
        this.downSampleLock.writeLock().lock();
        try {
            int result = this.baseSet != null ? this.baseSet.hashCode() : 0;
            result = 31 * result + this.maxSetSize;
            int n = result = 31 * result + this.currentSampleRate;
            return n;
        }
        finally {
            this.downSampleLock.writeLock().unlock();
        }
    }

    public static class SerDeImpl<T>
    implements SerDe<SampledSet<T>> {
        private final SetFactory<T, SnapshotableSet<T>> setFactory;
        private final DigestFunction<T> digestFunction;
        private final SerDe<T> elementSerDe;

        public SerDeImpl(SetFactory<T, SnapshotableSet<T>> setFactory, DigestFunction<T> digestFunction, SerDe<T> elementSerDe) {
            this.setFactory = setFactory;
            this.digestFunction = digestFunction;
            this.elementSerDe = elementSerDe;
        }

        public SampledSet<T> deserialize(DataInput in) throws SerDeException {
            try {
                int maxSize = in.readInt();
                int sampleRate = in.readInt();
                int numElements = in.readInt();
                SnapshotableSet<T> baseSet = this.setFactory.create();
                for (int i = 0; i < numElements; ++i) {
                    baseSet.add(this.elementSerDe.deserialize(in));
                }
                SampledSetImpl<T> sampledSet = new SampledSetImpl<T>(maxSize, this.digestFunction, baseSet, this.setFactory, sampleRate);
                return sampledSet;
            }
            catch (IOException e) {
                throw new SerDeException((Throwable)e);
            }
        }

        public void serialize(SampledSet<T> value, DataOutput out) throws SerDeException {
            try {
                SampledSetSnapshot<T> snapshot = value.sampleAt(0);
                SnapshotableSet<T> elements = snapshot.getElements();
                out.writeInt(snapshot.getMaxSetSize());
                out.writeInt(snapshot.getSampleRate());
                out.writeInt(elements.size());
                for (Object element : elements) {
                    this.elementSerDe.serialize(element, out);
                }
            }
            catch (IOException e) {
                throw new SerDeException((Throwable)e);
            }
        }
    }
}

