/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.SetFactory;
import com.facebook.collections.SetMap;
import com.facebook.collections.SetMapImpl;
import com.facebook.collections.Trackable;
import com.facebook.collections.WrappedIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class TrackableSetMap<K, V, S extends Set<V>>
implements SetMap<K, V, S>,
Trackable {
    private final SetMap<K, V, S> delegate;
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public TrackableSetMap(SetMap<K, V, S> delegate) {
        this.delegate = delegate;
    }

    public TrackableSetMap(SetFactory<V, S> setFactory) {
        this.delegate = new SetMapImpl(setFactory);
    }

    @Override
    public boolean add(K key, V item) {
        if (this.delegate.add(key, item)) {
            this.dirty.set(true);
            return true;
        }
        return false;
    }

    @Override
    public S removeSet(K key) {
        S value = this.delegate.removeSet(key);
        if (value != null) {
            this.dirty.set(true);
        }
        return value;
    }

    @Override
    public boolean remove(K key, V item) {
        if (this.delegate.remove(key, item)) {
            this.dirty.set(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.getAndSet(false);
    }

    @Override
    public S get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Iterator<Map.Entry<K, S>> iterator() {
        return new WrappedIterator<Map.Entry<K, S>>(this.delegate.iterator()){

            @Override
            public void remove() {
                super.remove();
                TrackableSetMap.this.dirty.set(true);
            }
        };
    }
}

