/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import javax.annotation.concurrent.GuardedBy;

public class DynamicIterator<T>
extends AbstractIterator<T> {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private final Semaphore available = new Semaphore(0);
    @GuardedBy(value="queue")
    private final Queue<T> queue;
    @GuardedBy(value="queue")
    private boolean finished;

    public DynamicIterator(int initialSize) {
        Preconditions.checkArgument((initialSize >= 0 ? 1 : 0) != 0, (Object)"initialSize must be >= 0");
        this.queue = new ArrayDeque<T>(initialSize);
    }

    public DynamicIterator() {
        this(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T element) throws InterruptedException {
        boolean added;
        Preconditions.checkNotNull(element, (Object)"element is null");
        Queue<T> queue = this.queue;
        synchronized (queue) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (String)"%s already finished", (Object)((Object)((Object)this)).getClass().getName());
            added = this.queue.add(element);
        }
        if (added) {
            this.available.release();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Queue<T> queue = this.queue;
        synchronized (queue) {
            this.finished = true;
        }
        this.available.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T computeNext() {
        try {
            this.available.acquire();
            Queue<T> queue = this.queue;
            synchronized (queue) {
                T element = this.queue.poll();
                if (element == null) {
                    Preconditions.checkState((boolean)this.finished, (Object)"Expected iterator to be finished");
                    this.endOfData();
                }
                return element;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

