/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

public class HostPort {
    private final String host;
    private final int port;
    private volatile String toStringResult;

    public static HostPort fromString(String str) {
        String[] parts = str.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid host:post string: " + str);
        }
        return new HostPort(parts[0], Integer.valueOf(parts[1]));
    }

    public HostPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPort hostPort = (HostPort)o;
        if (this.port != hostPort.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(hostPort.host) : hostPort.host != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        if (this.toStringResult == null) {
            this.toStringResult = this.host + ":" + this.port;
        }
        return this.toStringResult;
    }
}

