/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.google.common.reflect.TypeToken;

public class Key<K, V> {
    private K name;
    private TypeToken<V> type;

    public Key(K id, TypeToken<V> type) {
        this.name = id;
        this.type = type;
    }

    public Key(K id, Class<V> clazz) {
        this.name = id;
        this.type = TypeToken.of(clazz);
    }

    public static <K, V> Key<K, V> get(K id, Class<V> clazz) {
        return new Key<K, V>(id, clazz);
    }

    public static <K, V> Key<K, V> get(K id, TypeToken<V> clazz) {
        return new Key<K, V>(id, clazz);
    }

    public K getName() {
        return this.name;
    }

    public TypeToken<V> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (!this.type.equals(key.type)) {
            return false;
        }
        return this.name.equals(key.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

