/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import com.facebook.collections.Array;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LongArray
implements Array<Long> {
    private static final int DEFAULT_INITIAL_CAPACITY = 3;
    private static final double MIN_GROWTH_FACTOR = 0.3;
    private static final int MIN_GROWTH_AMOUNT = 8;
    private static final long EMPTY = -1L;
    private long[] data;
    private volatile int nextWritePosition = 0;
    private volatile int size = 0;

    public LongArray(int initialCapacity) {
        this.data = new long[initialCapacity];
        Arrays.fill(this.data, -1L);
    }

    public LongArray() {
        this(3);
    }

    @Override
    public synchronized Long get(int i) throws IndexOutOfBoundsException {
        if (i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[i] >= 0L ? Long.valueOf(this.data[i]) : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized int capacity() {
        return this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long set(int i, Long value) throws ArrayIndexOutOfBoundsException {
        if (value == null) {
            throw new NullPointerException("null values not allowed");
        }
        LongArray longArray = this;
        synchronized (longArray) {
            if (i >= this.data.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("tried to set value at index %d, but  max index is %d", i, this.data.length - 1));
            }
            Long oldValue = this.data[i];
            this.data[i] = value;
            if (oldValue == -1L) {
                ++this.size;
            }
            return oldValue;
        }
    }

    @Override
    public synchronized int append(Long value) {
        if (this.nextWritePosition >= this.data.length) {
            int sizeIncrease = (int)((double)this.data.length * 0.3);
            sizeIncrease = Math.max(sizeIncrease, 8);
            this.internalResize(this.data.length + sizeIncrease);
        }
        while (!this.isEmpty(this.nextWritePosition)) {
            ++this.nextWritePosition;
            if (this.nextWritePosition < this.data.length - 1) continue;
            this.resize(this.data.length + 8);
        }
        Preconditions.checkState((this.isEmpty(this.nextWritePosition) && this.nextWritePosition < this.data.length ? 1 : 0) != 0);
        int myWritePosition = this.nextWritePosition++;
        ++this.size;
        this.data[myWritePosition] = value;
        return myWritePosition;
    }

    @Override
    public synchronized Long remove(int i) throws ArrayIndexOutOfBoundsException {
        if (this.isEmpty(i)) {
            return null;
        }
        Long previousValue = this.data[i];
        this.data[i] = -1L;
        --this.size;
        return this.convertValue(previousValue);
    }

    @Override
    public int resize(int sizeHint) {
        return this.internalResize(sizeHint);
    }

    private synchronized int internalResize(int sizeHint) {
        Preconditions.checkArgument((sizeHint > 0 ? 1 : 0) != 0, (Object)"sizeHint must be > 0");
        int newSize = sizeHint;
        long[] newData = new long[newSize];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        Arrays.fill(newData, this.data.length, newData.length, -1L);
        this.data = newData;
        return newSize;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iter();
    }

    private Long convertValue(long value) {
        return value >= 0L ? Long.valueOf(value) : null;
    }

    private boolean isEmpty(int position) {
        return this.data[position] < 0L;
    }

    static /* synthetic */ int access$100(LongArray x0) {
        return x0.size;
    }

    private class Iter
    implements Iterator<Long> {
        private int position = 0;
        private int lastReadPosition = -2;
        private int numSeen = 0;
        private long sizeSnapshot = LongArray.access$100(LongArray.this);
        private int capacitySnapshot = LongArray.access$200(LongArray.this).length;
        private Long nextValue = null;
        private boolean readNextValue = false;
        private boolean hasNextValue = false;

        private Iter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            LongArray longArray = LongArray.this;
            synchronized (longArray) {
                boolean retVal;
                if (this.readNextValue) {
                    return this.hasNextValue;
                }
                boolean bl = retVal = (long)this.numSeen < this.sizeSnapshot && this.position < this.capacitySnapshot;
                while (retVal) {
                    this.nextValue = LongArray.this.convertValue(LongArray.this.data[this.position]);
                    if (this.nextValue != null) break;
                    ++this.position;
                    retVal = (long)this.numSeen < this.sizeSnapshot && this.position < this.capacitySnapshot;
                }
                if (retVal) {
                    this.lastReadPosition = this.position;
                }
                this.readNextValue = true;
                this.hasNextValue = retVal;
                return retVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long next() {
            LongArray longArray = LongArray.this;
            synchronized (longArray) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.readNextValue = false;
                ++this.position;
                return this.nextValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            LongArray longArray = LongArray.this;
            synchronized (longArray) {
                if (this.lastReadPosition == -2) {
                    throw new IllegalStateException("next() has not been called yet");
                }
                if (this.lastReadPosition == -1) {
                    throw new IllegalStateException("remove already called for this position");
                }
                ((LongArray)LongArray.this).data[this.lastReadPosition] = -1L;
                LongArray.this.size--;
                this.lastReadPosition = -1;
            }
        }
    }
}

