/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PackedByteArray {
    private static final byte DEFAULT_DELIMITER = 1;
    private static final byte DEFAULT_TERMINAL_DELIMITER = 0;
    private static final int MAGIC_INITIAL_BYTE_ARRAY_SIZE = 256;

    public static byte[] pack(byte[] ... arrays) {
        return PackedByteArray.pack(Arrays.asList(arrays));
    }

    public static byte[] readByteArray(DataInput in, byte terminalDelimiter) throws IOException {
        byte b;
        ArrayList<Byte> byteList = new ArrayList<Byte>(256);
        while ((b = in.readByte()) != terminalDelimiter) {
            byteList.add(b);
        }
        return PackedByteArray.byteListToArray(byteList);
    }

    public static List<byte[]> readByteArrayList(DataInput in, byte delimiter, byte terminalDelimiter) throws IOException {
        byte b;
        ArrayList<Byte> byteList = new ArrayList<Byte>(256);
        while ((b = in.readByte()) != terminalDelimiter) {
            byteList.add(b);
        }
        byteList.add(terminalDelimiter);
        return PackedByteArray.unpackComparable(PackedByteArray.byteListToArray(byteList), delimiter, terminalDelimiter);
    }

    public static byte[] packComparable(byte[] ... arrays) {
        return PackedByteArray.packComparable(Arrays.asList(arrays));
    }

    public static byte[] packComparable(List<byte[]> arrays) {
        return PackedByteArray.packComparable(arrays, (byte)1, (byte)0);
    }

    public static byte[] packComparable(List<byte[]> arrays, byte delimiter, byte terminalDelimiter) {
        int packedSize = 0;
        for (byte[] array : arrays) {
            packedSize += array.length + 1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(packedSize);
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        try {
            boolean first = true;
            for (byte[] array : arrays) {
                if (!first) {
                    output.write(delimiter);
                }
                output.write(array);
                first = false;
            }
            output.write(terminalDelimiter);
        }
        catch (IOException e) {
            throw new RuntimeException("no reason we should see this", e);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return bytes;
    }

    public static List<byte[]> unpackComparable(byte[] packedArray) {
        return PackedByteArray.unpackComparable(packedArray, (byte)1, (byte)0);
    }

    public static List<byte[]> unpackComparable(byte[] packedArray, byte delimiter, byte terminalDelimiter) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        ArrayList<Byte> currentToken = new ArrayList<Byte>(256);
        for (int i = 0; i < packedArray.length; ++i) {
            if (packedArray[i] == terminalDelimiter) {
                results.add(PackedByteArray.byteListToArray(currentToken));
                break;
            }
            if (packedArray[i] == delimiter) {
                results.add(PackedByteArray.byteListToArray(currentToken));
                currentToken = new ArrayList(256);
                continue;
            }
            currentToken.add(packedArray[i]);
        }
        return results;
    }

    public static byte[] pack(List<byte[]> arrays) {
        int packedSize = 2 + 4 * arrays.size();
        for (byte[] array : arrays) {
            packedSize += array.length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(packedSize);
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        try {
            output.writeShort(arrays.size());
            for (byte[] array : arrays) {
                output.writeInt(array.length);
            }
            for (byte[] array : arrays) {
                output.write(array);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("no reason we should see this", e);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return bytes;
    }

    public static byte[][] unpack(byte[] packedArray) {
        try {
            int i;
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(packedArray));
            int numItems = input.readShort();
            assert (numItems >= 0);
            int[] lens = new int[numItems];
            byte[][] arrays = new byte[numItems][];
            for (i = 0; i < numItems; ++i) {
                lens[i] = input.readInt();
            }
            for (i = 0; i < numItems; ++i) {
                arrays[i] = new byte[lens[i]];
                input.readFully(arrays[i]);
            }
            return arrays;
        }
        catch (IOException e) {
            throw new RuntimeException("shouldn't see this either", e);
        }
    }

    public static byte[] getElement(byte[] packedArray, int pos) {
        int numItems = packedArray[0] << 8 | packedArray[1];
        if (pos > numItems - 1) {
            throw new IllegalArgumentException(String.format("index %d is greater than max %d", pos, numItems - 1));
        }
        int dataPtr = 2 + numItems * 4;
        int dataLen = 0;
        for (int i = 0; i < numItems; ++i) {
            int j = 2 + i * 4;
            int len = PackedByteArray.byteToInt(packedArray, j);
            assert (len >= 0);
            if (i < pos) {
                dataPtr += len;
                continue;
            }
            dataLen = len;
            break;
        }
        return Arrays.copyOfRange(packedArray, dataPtr, dataPtr + dataLen);
    }

    public static int byteToIntAlt(byte[] bytes, int i) {
        int value;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes, i, 4));
        try {
            value = stream.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public static byte[] byteListToArray(List<Byte> byteList) {
        byte[] result = new byte[byteList.size()];
        int i = 0;
        for (Byte b : byteList) {
            result[i++] = b;
        }
        return result;
    }

    public static int byteToInt(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 1] & 0xFF) << 16) + (bytes[offset] << 24);
    }
}

