/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

public class Pair<First, Second> {
    private final First first;
    private final Second second;
    private volatile String toStringResult;

    public Pair(First first, Second second) {
        this.first = first;
        this.second = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public First getFirst() {
        return this.first;
    }

    public Second getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.first != null ? !this.first.equals(pair.first) : pair.first != null) {
            return false;
        }
        return !(this.second != null ? !this.second.equals(pair.second) : pair.second != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.toStringResult == null) {
            this.toStringResult = "Pair{first=" + this.first + ", second=" + this.second + '}';
        }
        return this.toStringResult;
    }
}

