/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RetrieveableSet<T>
implements Set<T> {
    private final Map<T, T> identityMap;

    public RetrieveableSet(Map<T, T> identityMap) {
        this.identityMap = identityMap;
    }

    public RetrieveableSet() {
        this(new HashMap());
    }

    public T get(T t) {
        return this.identityMap.get(t);
    }

    @Override
    public int size() {
        return this.identityMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.identityMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.identityMap.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.identityMap.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.identityMap.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.identityMap.keySet().toArray(ts);
    }

    @Override
    public boolean add(T t) {
        if (this.identityMap.containsKey(t)) {
            return false;
        }
        this.identityMap.put(t, t);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.identityMap.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.identityMap.keySet().containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        boolean changed = false;
        for (T t : ts) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.identityMap.keySet().retainAll(objects);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.identityMap.keySet().removeAll(objects);
    }

    @Override
    public void clear() {
        this.identityMap.clear();
    }
}

