/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import com.facebook.collections.specialized.LongTupleHeap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongTupleList
implements LongTupleHeap {
    private static final int SORT_INDEX = 0;
    private static final int DEFAULT_INITIAL_LIST_SIZE = 1;
    private static final int DEFAULT_TUPLE_SIZE = 2;
    private static final int ALLOCATION_CHUNK_SIZE = 1;
    private static final int EMPTY = -1;
    private long[] tuples;
    private volatile int size = 0;

    protected AbstractLongTupleList(int initialListSize, int tupleSize) {
        this.tuples = new long[initialListSize * tupleSize];
        Arrays.fill(this.tuples, -1L);
        this.setHeadIndex(0);
    }

    protected AbstractLongTupleList(long[] tuples, int size) {
        this.tuples = tuples;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLongTupleList(AbstractLongTupleList otherTupleList) {
        AbstractLongTupleList abstractLongTupleList = otherTupleList;
        synchronized (abstractLongTupleList) {
            if (this.getTupleSize() != otherTupleList.getTupleSize()) {
                throw new IllegalArgumentException(String.format("mismatched tuple sizes: [%d] and [%d]", this.getTupleSize(), otherTupleList.getTupleSize()));
            }
            this.tuples = Arrays.copyOf(otherTupleList.tuples, otherTupleList.tuples.length);
            this.size = otherTupleList.size;
        }
    }

    protected abstract int getTupleSize();

    protected abstract LongTupleHeap copyHeap(long[] var1, int var2);

    @Override
    public synchronized long[] peek() {
        return this.findSmallest(false);
    }

    @Override
    public synchronized long[] poll() {
        return this.findSmallest(true);
    }

    @Override
    public synchronized boolean add(long[] tuple) {
        int insertLocation;
        if (tuple.length != this.getTupleSize()) {
            throw new IllegalArgumentException(String.format("tuples must be of size %d ", this.getTupleSize()));
        }
        if (tuple[0] < 0L) {
            throw new IllegalArgumentException(String.format("tuple[%d] with value %d is not >= 0 ", 0, tuple[0]));
        }
        if (!this.spaceFor(1)) {
            this.resize();
        }
        if ((insertLocation = this.findInsertLocation(tuple[0])) >= this.tuples.length) {
            int numShifted = this.getTupleSize() * this.leftCompact();
            insertLocation -= numShifted;
        } else if (!this.isEmpty(insertLocation)) {
            insertLocation = this.rightShift(insertLocation);
        }
        this.insertAt(tuple, insertLocation);
        this.updateHeadIndex(insertLocation);
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends long[]> tuples) {
        throw new UnsupportedOperationException("not yet");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized int shrink() {
        if (this.size == 0 || this.translate(this.size) == this.tuples.length) {
            return 0;
        }
        this.leftCompact();
        int minSize = Math.max(1, this.size);
        int rawSize = this.getTupleSize() * minSize;
        int saved = this.tuples.length - rawSize;
        long[] newTuples = new long[rawSize];
        if (this.size > 0) {
            System.arraycopy(this.tuples, 0, newTuples, 0, rawSize);
        } else {
            Arrays.fill(newTuples, -1L);
            newTuples[0] = 0L;
        }
        this.tuples = newTuples;
        return saved;
    }

    @Override
    public synchronized LongTupleHeap makeCopy() {
        return this.copyHeap(this.tuples, this.size);
    }

    @Override
    public Iterator<long[]> iterator() {
        return new Iter();
    }

    private int leftCompact() {
        if (this.size == 0) {
            return 0;
        }
        int headLength = this.getHeadIndex();
        if (headLength == 0) {
            return 0;
        }
        System.arraycopy(this.tuples, headLength, this.tuples, 0, this.translate(this.size));
        return headLength;
    }

    private int leftCompactSparse() {
        int translatedWritePosition = 0;
        int translatedReadPosition = this.getTupleSize();
        int numProcessed = 0;
        int emptySlots = 1;
        while (numProcessed < this.size) {
            if (this.isEmpty(translatedWritePosition)) {
                while (this.isEmpty(translatedReadPosition) && translatedReadPosition < this.tuples.length) {
                    translatedReadPosition += this.getTupleSize();
                    ++emptySlots;
                }
                if (translatedReadPosition >= this.tuples.length) {
                    throw new IllegalStateException("compact failed--couldn't find non-empty to copy to empty");
                }
                this.swap(translatedWritePosition, translatedReadPosition);
            }
            ++numProcessed;
            translatedWritePosition += this.getTupleSize();
            translatedReadPosition += this.getTupleSize();
        }
        return emptySlots;
    }

    private void swap(int firstTranslatedPosition, int secondTranslatedPosition) {
        long[] tmpList = new long[this.getTupleSize()];
        System.arraycopy(this.tuples, firstTranslatedPosition, tmpList, 0, this.getTupleSize());
        System.arraycopy(this.tuples, secondTranslatedPosition, this.tuples, firstTranslatedPosition, this.getTupleSize());
        System.arraycopy(tmpList, 0, this.tuples, secondTranslatedPosition, this.getTupleSize());
    }

    private int findInsertLocation(long value) {
        int i;
        int startIndex = this.getHeadIndex();
        int endIndex = startIndex + this.translate(this.size);
        for (i = startIndex; i < endIndex; i += this.getTupleSize()) {
            if (startIndex >= this.getTupleSize() && this.isEmpty(i - this.getTupleSize()) && this.tuples[i] >= value) {
                return i - this.getTupleSize();
            }
            if (this.isEmpty(i) || this.tuples[i] >= value) break;
        }
        return i;
    }

    private int rightShift(int start) {
        if (!this.isEmpty(this.tuples.length - this.getTupleSize())) {
            int numShifted = this.getTupleSize() * this.leftCompact();
            start -= numShifted;
        }
        int endIndex = this.getHeadIndex() + this.translate(this.size) - 1;
        System.arraycopy(this.tuples, start, this.tuples, start + this.getTupleSize(), endIndex - start + 1);
        return start;
    }

    private boolean isEmpty(int position) {
        return this.tuples[position] < 0L;
    }

    private boolean spaceFor(int numItems) {
        return this.translate(this.size - 1) + this.getTupleSize() * numItems < this.tuples.length;
    }

    private void insertAt(long[] tuple, int translatedPosition) {
        if (tuple.length != this.getTupleSize()) {
            throw new IllegalArgumentException(String.format("tuples must be of size %d ", this.getTupleSize()));
        }
        int i = 0;
        long[] lArray = tuple;
        int n = lArray.length;
        for (int j = 0; j < n; ++j) {
            long item;
            this.tuples[translatedPosition + i] = item = lArray[j];
            ++i;
        }
        ++this.size;
    }

    private void resize() {
        int newSize = this.getTupleSize() * (this.size + 1);
        long[] replacement = new long[newSize];
        System.arraycopy(this.tuples, 0, replacement, 0, this.tuples.length);
        Arrays.fill(replacement, this.tuples.length, replacement.length, -1L);
        this.tuples = replacement;
    }

    private long[] findSmallest(boolean remove) {
        if (this.size == 0) {
            return null;
        }
        int headIndex = this.getHeadIndex();
        long[] tupleAt = this.getTupleAt(headIndex);
        if (remove) {
            this.tuples[headIndex] = -1L;
            this.setHeadIndex(headIndex + this.getTupleSize());
            --this.size;
        }
        return tupleAt;
    }

    private int getHeadIndex() {
        if (this.tuples[0] < 0L) {
            return (int)(-1L * this.tuples[0]);
        }
        return 0;
    }

    private void setHeadIndex(int index) {
        if (this.tuples[0] >= 0L) {
            throw new IllegalStateException(String.format("trying to set head index when not empty. value: %d", this.tuples[0]));
        }
        this.tuples[0] = -index;
    }

    private void updateHeadIndex(int insertLocation) {
        int headIndex = this.getHeadIndex();
        if (headIndex > insertLocation) {
            this.setHeadIndex(insertLocation);
        }
    }

    private int translate(int position) {
        return this.getTupleSize() * position;
    }

    private int invertTranslation(int translatedPosition) {
        return translatedPosition / this.getTupleSize();
    }

    private long[] getTupleAt(int translatedPosition) {
        long[] result = new long[this.getTupleSize()];
        System.arraycopy(this.tuples, translatedPosition, result, 0, this.getTupleSize());
        return result;
    }

    private class Iter
    implements Iterator<long[]> {
        private int position;
        private long[] nextValue;

        private Iter() {
            this.position = AbstractLongTupleList.this.getHeadIndex() / AbstractLongTupleList.this.getTupleSize();
            this.nextValue = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            boolean hasNext = true;
            AbstractLongTupleList abstractLongTupleList = AbstractLongTupleList.this;
            synchronized (abstractLongTupleList) {
                if (this.nextValue == null) {
                    int translatedPosition;
                    int translatedSize = AbstractLongTupleList.this.translate(AbstractLongTupleList.this.size);
                    for (translatedPosition = AbstractLongTupleList.this.translate(this.position); translatedPosition < translatedSize && AbstractLongTupleList.this.isEmpty(translatedPosition); translatedPosition += AbstractLongTupleList.this.getTupleSize()) {
                    }
                    boolean bl = hasNext = translatedPosition < translatedSize;
                    if (hasNext) {
                        this.position = AbstractLongTupleList.this.invertTranslation(translatedPosition);
                        this.nextValue = AbstractLongTupleList.this.getTupleAt(translatedPosition);
                    }
                }
            }
            return hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long[] next() {
            AbstractLongTupleList abstractLongTupleList = AbstractLongTupleList.this;
            synchronized (abstractLongTupleList) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException(String.format("position: %d, nextValue %s", this.position, this.nextValue));
                }
                ++this.position;
                long[] result = this.nextValue;
                this.nextValue = null;
                return result;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported; read-only");
        }
    }
}

