/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import cern.colt.list.LongArrayList;
import cern.colt.map.OpenLongObjectHashMap;
import com.facebook.collections.specialized.SnapshotableSet;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColtHashSet
extends AbstractSet<Long>
implements SnapshotableSet<Long> {
    private static final Object TRUE = new Object();
    private final OpenLongObjectHashMap map;
    private volatile long version = Long.MIN_VALUE;

    public ColtHashSet(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.map = new OpenLongObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public ColtHashSet(int initialCapacity) {
        this.map = new OpenLongObjectHashMap(initialCapacity);
    }

    @Override
    public synchronized boolean add(Long aLong) {
        ++this.version;
        return this.map.put(aLong.longValue(), TRUE);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iter();
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public SnapshotableSet<Long> makeSnapshot() {
        return (SnapshotableSet)this.map.clone();
    }

    @Override
    public SnapshotableSet<Long> makeTransientSnapshot() {
        return this.makeSnapshot();
    }

    private class Iter
    implements Iterator<Long> {
        private final LongArrayList mapKeyList;
        private int index;
        private long versionSnapshot;
        private boolean canRemove;

        private Iter() {
            this.mapKeyList = ColtHashSet.this.map.keys();
            this.index = 0;
            this.versionSnapshot = ColtHashSet.this.version;
            this.canRemove = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ColtHashSet coltHashSet = ColtHashSet.this;
            synchronized (coltHashSet) {
                return this.index < this.mapKeyList.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long next() {
            ColtHashSet coltHashSet = ColtHashSet.this;
            synchronized (coltHashSet) {
                if (this.versionSnapshot != ColtHashSet.this.version) {
                    throw new ConcurrentModificationException();
                }
                if (this.index >= this.mapKeyList.size()) {
                    throw new NoSuchElementException();
                }
                long value = this.mapKeyList.getQuick(this.index);
                ++this.index;
                this.canRemove = true;
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ColtHashSet coltHashSet = ColtHashSet.this;
            synchronized (coltHashSet) {
                if (!this.canRemove) {
                    throw new IllegalStateException("repeated remove() calls or next() not called");
                }
                ColtHashSet.this.map.removeKey(this.mapKeyList.get(this.index - 1));
                this.canRemove = false;
                ColtHashSet.this.version++;
                this.versionSnapshot = ColtHashSet.this.version;
            }
        }
    }
}

