/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.facebook.collections.specialized.SnapshotableSet;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColtIntegerHashSet
extends AbstractSet<Long>
implements SnapshotableSet<Long> {
    private static final Object TRUE = new Object();
    private final OpenIntObjectHashMap map;
    private volatile long version = Long.MIN_VALUE;

    ColtIntegerHashSet(OpenIntObjectHashMap map) {
        this.map = map;
    }

    public ColtIntegerHashSet(int initialCapacity) {
        this.map = new OpenIntObjectHashMap(initialCapacity);
    }

    @Override
    public synchronized boolean add(Long aLong) {
        ++this.version;
        return this.map.put(aLong.intValue(), TRUE);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iter();
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public SnapshotableSet<Long> makeSnapshot() {
        OpenIntObjectHashMap mapCopy = (OpenIntObjectHashMap)this.map.clone();
        ColtIntegerHashSet thisCopy = new ColtIntegerHashSet(mapCopy);
        return thisCopy;
    }

    @Override
    public SnapshotableSet<Long> makeTransientSnapshot() {
        return this.makeSnapshot();
    }

    private class Iter
    implements Iterator<Long> {
        private final IntArrayList mapKeyList;
        private int index;
        private long versionSnapshot;
        private boolean canRemove;

        private Iter() {
            this.mapKeyList = ColtIntegerHashSet.this.map.keys();
            this.index = 0;
            this.versionSnapshot = ColtIntegerHashSet.this.version;
            this.canRemove = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ColtIntegerHashSet coltIntegerHashSet = ColtIntegerHashSet.this;
            synchronized (coltIntegerHashSet) {
                return this.index < this.mapKeyList.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long next() {
            ColtIntegerHashSet coltIntegerHashSet = ColtIntegerHashSet.this;
            synchronized (coltIntegerHashSet) {
                if (this.versionSnapshot != ColtIntegerHashSet.this.version) {
                    throw new ConcurrentModificationException();
                }
                if (this.index >= this.mapKeyList.size()) {
                    throw new NoSuchElementException();
                }
                long value = this.mapKeyList.getQuick(this.index);
                ++this.index;
                this.canRemove = true;
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ColtIntegerHashSet coltIntegerHashSet = ColtIntegerHashSet.this;
            synchronized (coltIntegerHashSet) {
                if (!this.canRemove) {
                    throw new IllegalStateException("repeated remove() calls or next() not called");
                }
                ColtIntegerHashSet.this.map.removeKey(this.mapKeyList.get(this.index - 1));
                this.canRemove = false;
                ColtIntegerHashSet.this.version++;
                this.versionSnapshot = ColtIntegerHashSet.this.version;
            }
        }
    }
}

