/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.collections.specialized;

import cern.colt.list.LongArrayList;
import cern.colt.map.OpenLongObjectHashMap;
import com.facebook.collections.specialized.SnapshotableSet;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColtLongHashSet
extends AbstractSet<Long>
implements SnapshotableSet<Long> {
    private static final Object TRUE = new Object();
    private final OpenLongObjectHashMap map;
    private volatile long version = Long.MIN_VALUE;

    ColtLongHashSet(OpenLongObjectHashMap map) {
        this.map = map;
    }

    public ColtLongHashSet(int initialCapacity) {
        this.map = new OpenLongObjectHashMap(initialCapacity);
    }

    @Override
    public synchronized boolean add(Long aLong) {
        ++this.version;
        return this.map.put(aLong.longValue(), TRUE);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iter();
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public SnapshotableSet<Long> makeSnapshot() {
        OpenLongObjectHashMap mapCopy = (OpenLongObjectHashMap)this.map.clone();
        ColtLongHashSet thisCopy = new ColtLongHashSet(mapCopy);
        return thisCopy;
    }

    @Override
    public SnapshotableSet<Long> makeTransientSnapshot() {
        return this.makeSnapshot();
    }

    private class Iter
    implements Iterator<Long> {
        private final LongArrayList mapKeyList;
        private int index;
        private long versionSnapshot;
        private boolean canRemove;

        private Iter() {
            this.mapKeyList = ColtLongHashSet.this.map.keys();
            this.index = 0;
            this.versionSnapshot = ColtLongHashSet.this.version;
            this.canRemove = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ColtLongHashSet coltLongHashSet = ColtLongHashSet.this;
            synchronized (coltLongHashSet) {
                return this.index < this.mapKeyList.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long next() {
            ColtLongHashSet coltLongHashSet = ColtLongHashSet.this;
            synchronized (coltLongHashSet) {
                if (this.versionSnapshot != ColtLongHashSet.this.version) {
                    throw new ConcurrentModificationException();
                }
                if (this.index >= this.mapKeyList.size()) {
                    throw new NoSuchElementException();
                }
                long value = this.mapKeyList.getQuick(this.index);
                ++this.index;
                this.canRemove = true;
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ColtLongHashSet coltLongHashSet = ColtLongHashSet.this;
            synchronized (coltLongHashSet) {
                if (!this.canRemove) {
                    throw new IllegalStateException("repeated remove() calls or next() not called");
                }
                ColtLongHashSet.this.map.removeKey(this.mapKeyList.get(this.index - 1));
                this.canRemove = false;
                ColtLongHashSet.this.version++;
                this.versionSnapshot = ColtLongHashSet.this.version;
            }
        }
    }
}

