/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.CallableSnapshot;
import com.facebook.concurrency.ConcurrentCache;
import com.facebook.concurrency.ValueFactory;
import com.facebook.util.exceptions.ExceptionHandler;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class CaffeineConcurrentCache<K, V, E extends Exception>
implements ConcurrentCache<K, V, E> {
    private final LoadingCache<K, CallableSnapshot<V, E>> cache;
    private final ExceptionHandler<E> exceptionHandler;
    private final ConcurrentMap<K, CallableSnapshot<V, E>> cacheAsMap;

    public CaffeineConcurrentCache(ValueFactory<K, V, E> valueFactory, ExceptionHandler<E> exceptionHandler, Caffeine<Object, Object> cacheBuilder) {
        this.exceptionHandler = exceptionHandler;
        this.cache = cacheBuilder.build(new CacheValueLoader(valueFactory, exceptionHandler));
        this.cacheAsMap = this.cache.asMap();
    }

    public CaffeineConcurrentCache(ValueFactory<K, V, E> valueFactory, ExceptionHandler<E> exceptionHandler) {
        this(valueFactory, exceptionHandler, (Caffeine<Object, Object>)Caffeine.newBuilder());
    }

    @Override
    public V get(K key) throws E {
        return ((CallableSnapshot)this.cache.get(key)).get();
    }

    @Override
    public V put(K key, V value) throws E {
        CallableSnapshot<Object, E> putResult = this.cacheAsMap.put(key, new CallableSnapshot<Object, E>(() -> value, this.exceptionHandler));
        return (V)(putResult == null ? null : putResult.get());
    }

    @Override
    public V remove(K key) throws E {
        CallableSnapshot removeResult = (CallableSnapshot)this.cacheAsMap.remove(key);
        return removeResult == null ? null : (V)removeResult.get();
    }

    @Override
    public boolean removeIfError(K key) {
        CallableSnapshot snapshot = (CallableSnapshot)this.cache.getIfPresent(key);
        if (snapshot != null && snapshot.getException() != null) {
            this.cacheAsMap.remove(key, snapshot);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void prune() {
        this.cache.cleanUp();
    }

    @Override
    public int size() {
        long sizeInLong = this.cache.estimatedSize();
        Preconditions.checkState((sizeInLong < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"overflow on cache size");
        return (int)sizeInLong;
    }

    @Override
    public Iterator<Map.Entry<K, CallableSnapshot<V, E>>> iterator() {
        Iterator<Map.Entry<K, CallableSnapshot<V, E>>> iterator = this.cacheAsMap.entrySet().iterator();
        return iterator;
    }

    @Override
    public CallableSnapshot<V, E> getIfPresent(K key) {
        return (CallableSnapshot)this.cache.getIfPresent(key);
    }

    private static class CacheValueLoader<K, V, E extends Exception>
    implements CacheLoader<K, CallableSnapshot<V, E>> {
        private final ValueFactory<K, V, E> valueFactory;
        private final ExceptionHandler<E> exceptionHandler;

        private CacheValueLoader(ValueFactory<K, V, E> valueFactory, ExceptionHandler<E> exceptionHandler) {
            this.valueFactory = valueFactory;
            this.exceptionHandler = exceptionHandler;
        }

        public CallableSnapshot<V, E> load(K key) {
            try {
                Object value = this.valueFactory.create(key);
                return new CallableSnapshot<Object, E>(() -> value, this.exceptionHandler);
            }
            catch (Exception e) {
                return CallableSnapshot.createWithException(this.exceptionHandler.handle(e));
            }
        }
    }
}

