/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.util.exceptions.ExceptionHandler;
import java.util.concurrent.Callable;

public class CallableSnapshot<V, E extends Exception> {
    private V value = null;
    private E exception = null;

    private CallableSnapshot(E exception) {
        this.exception = exception;
    }

    public CallableSnapshot(Callable<V> callable, ExceptionHandler<E> exceptionHandler) {
        try {
            this.value = callable.call();
        }
        catch (Exception e) {
            this.exception = exceptionHandler.handle(e);
        }
    }

    public static <V, E extends Exception> CallableSnapshot<V, E> createWithException(E exception) {
        return new CallableSnapshot<V, E>(exception);
    }

    public V get() throws E {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public E getException() {
        return this.exception;
    }
}

