/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.util.exceptions.ExceptionHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CastOrWrapExceptionHandler<T extends Exception>
implements ExceptionHandler<T> {
    private final Class<T> exceptionClass;

    public CastOrWrapExceptionHandler(Class<T> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public <S extends Exception> T handle(S e) {
        if (this.exceptionClass.isAssignableFrom(e.getClass())) {
            return (T)e;
        }
        try {
            Constructor<T> constructor = this.exceptionClass.getConstructor(Throwable.class);
            return (T)((Exception)constructor.newInstance(e));
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        catch (InvocationTargetException e1) {
            throw new RuntimeException(e1);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException(e1);
        }
    }
}

