/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.ParallelRunner;
import com.facebook.concurrency.ShortCircuitRunnable;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.facebook.util.ExtRunnable;
import com.facebook.util.exceptions.ExceptionHandler;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrencyUtil {
    private static final Logger LOG = LoggerImpl.getLogger(ConcurrencyUtil.class);
    private static final AtomicLong INSTANCE_NUMBER = new AtomicLong(0L);
    private static final ReadWriteLock SHUTDOWN_LOCK = new ReentrantReadWriteLock();
    private static final ExecutorService CACHED_EXECUTOR = Executors.newCachedThreadPool();
    private static final ParallelRunner PARALLEL_RUNNER = new ParallelRunner(CACHED_EXECUTOR, "ParallelRunExt-");
    private static final int AWAIT_TERMINATION_SECONDS = 30;

    public static Runnable shutdownExecutorTask(final ExecutorService executor) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    executor.shutdown();
                    if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                        LOG.warn("executor didn't finish shutting down in %d seconds, moving on", new Object[]{30});
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("interrupted shutting down executor", new Object[0]);
                }
            }
        };
    }

    public static <E extends Exception> void parallelRunExt(Iterable<? extends ExtRunnable<E>> tasks, int numThreads, ExceptionHandler<E> exceptionHandler) throws E {
        ConcurrencyUtil.parallelRunExt(tasks.iterator(), numThreads, exceptionHandler);
    }

    public static <E extends Exception> void parallelRunExt(Iterator<? extends ExtRunnable<E>> tasksIter, int numThreads, ExceptionHandler<E> exceptionHandler) throws E {
        ConcurrencyUtil.parallelRunExt(tasksIter, numThreads, exceptionHandler, "ParallelRunExt-" + INSTANCE_NUMBER.getAndIncrement());
    }

    public static <E extends Exception> void parallelRunExt(Iterable<? extends ExtRunnable<E>> tasks, int numThreads, ExceptionHandler<E> exceptionHandler, String baseName) throws E {
        ConcurrencyUtil.parallelRunExt(tasks.iterator(), numThreads, exceptionHandler, baseName);
    }

    public static <E extends Exception> void parallelRunExt(Iterator<? extends ExtRunnable<E>> tasksIter, int numThreads, ExceptionHandler<E> exceptionHandler, String baseName) throws E {
        AtomicReference exception = new AtomicReference();
        Iterator wrappedIterator = Iterators.transform(tasksIter, new ShortCircuitRunnable(exception, exceptionHandler));
        ConcurrencyUtil.parallelRun(wrappedIterator, numThreads, baseName);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    public static void parallelRun(Iterable<? extends Runnable> tasks, int numThreads) {
        ConcurrencyUtil.parallelRun(tasks.iterator(), numThreads);
    }

    public static void parallelRun(Iterator<? extends Runnable> tasksIter, int numThreads) {
        ConcurrencyUtil.parallelRun(tasksIter, numThreads, "ParallelRun-" + INSTANCE_NUMBER.getAndIncrement());
    }

    public static void parallelRun(Iterable<? extends Runnable> tasks, int numThreads, String baseName) {
        ConcurrencyUtil.parallelRun(tasks.iterator(), numThreads, baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parallelRun(Iterator<? extends Runnable> tasksIter, int numThreads, String baseName) {
        SHUTDOWN_LOCK.readLock().lock();
        try {
            if (!CACHED_EXECUTOR.isShutdown()) {
                PARALLEL_RUNNER.parallelRun(tasksIter, numThreads, baseName);
            } else {
                ExecutorService executor = Executors.newFixedThreadPool(numThreads);
                ParallelRunner parallelRunner = new ParallelRunner(executor, "ParallelRunExt-");
                parallelRunner.parallelRun(tasksIter, numThreads, baseName);
                executor.shutdown();
            }
        }
        finally {
            SHUTDOWN_LOCK.readLock().unlock();
        }
    }

    public static void shutdown() {
        SHUTDOWN_LOCK.writeLock().lock();
        try {
            CACHED_EXECUTOR.shutdown();
        }
        finally {
            SHUTDOWN_LOCK.writeLock().unlock();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SHUTDOWN_LOCK.writeLock().lock();
                try {
                    CACHED_EXECUTOR.shutdown();
                }
                finally {
                    SHUTDOWN_LOCK.writeLock().unlock();
                }
            }
        }));
    }
}

