/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.collections.TranslatingIterator;
import com.facebook.collectionsbase.Mapper;
import com.facebook.concurrency.CallableSnapshot;
import com.facebook.concurrency.CastingExceptionHandler;
import com.facebook.concurrency.ConcurrentCache;
import com.facebook.concurrency.FutureHelper;
import com.facebook.concurrency.ValueFactory;
import com.facebook.util.exceptions.ExceptionHandler;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class CoreConcurrentCache<K, V, E extends Exception>
implements ConcurrentCache<K, V, E> {
    private final ConcurrentMap<K, Object> cache;
    private final ValueFactory<K, V, E> valueFactory;
    private final ExceptionHandler<E> exceptionHandler;

    protected CoreConcurrentCache(ValueFactory<K, V, E> valueFactory, ExceptionHandler<E> exceptionHandler, ConcurrentMap<K, Object> cache) {
        this.valueFactory = valueFactory;
        this.exceptionHandler = exceptionHandler;
        this.cache = cache;
    }

    public CoreConcurrentCache(ValueFactory<K, V, E> valueFactory, ExceptionHandler<E> exceptionHandler) {
        this(valueFactory, exceptionHandler, new ConcurrentHashMap());
    }

    @Override
    public V get(K key) throws E {
        Object value = this.cache.get(key);
        if (value == null) {
            AtomicReference valueRef = new AtomicReference();
            value = new PrivateFutureHelper(() -> {
                V producedValue = this.valueFactory.create(key);
                this.cache.replace(key, valueRef.get(), producedValue);
                return producedValue;
            }, this.exceptionHandler);
            valueRef.set(value);
            Object existingValue = this.cache.putIfAbsent(key, value);
            if (existingValue != null) {
                value = existingValue;
            }
        }
        return this.decodeValue(value);
    }

    @Override
    public V put(K key, V value) throws E {
        V existingValue = this.cache.put(key, value);
        return this.decodeValue(existingValue);
    }

    @Override
    public V remove(K key) throws E {
        Object value = this.cache.remove(key);
        if (value == null) {
            return null;
        }
        return this.decodeValue(value);
    }

    @Override
    public boolean removeIfError(K key) {
        Object value = this.cache.get(key);
        if (value != null && value instanceof PrivateFutureHelper && ((FutureHelper)value).isError()) {
            this.cache.remove(key, value);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void prune() {
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<K, CallableSnapshot<V, E>>> iterator() {
        return new TranslatingIterator((Mapper)new ValueMapper(), this.cache.entrySet().iterator());
    }

    @Override
    public CallableSnapshot<V, E> getIfPresent(K key) {
        Object value = this.cache.get(key);
        if (value == null) {
            return null;
        }
        return new CallableSnapshot(new CallableFutureHelper(value), new CastingExceptionHandler());
    }

    private V decodeValue(Object value) throws E {
        if (value instanceof PrivateFutureHelper) {
            return (V)((FutureHelper)value).safeGet();
        }
        return (V)value;
    }

    private static class PrivateFutureHelper<V2, E2 extends Exception>
    extends FutureHelper<V2, E2> {
        private PrivateFutureHelper(Callable<V2> callable, ExceptionHandler<E2> exceptionHandler) {
            super(callable, exceptionHandler);
        }
    }

    private class CallableFutureHelper
    implements Callable {
        private final Object value;

        private CallableFutureHelper(Object value) {
            this.value = value;
        }

        @Override
        public V call() throws Exception {
            return CoreConcurrentCache.this.decodeValue(this.value);
        }
    }

    private class ValueMapper
    implements Mapper<Map.Entry<K, Object>, Map.Entry<K, CallableSnapshot<V, E>>> {
        private ValueMapper() {
        }

        public Map.Entry<K, CallableSnapshot<V, E>> map(Map.Entry<K, Object> input) {
            return new AbstractMap.SimpleImmutableEntry(input.getKey(), new CallableSnapshot(new CallableFutureHelper(input.getValue()), new CastingExceptionHandler()));
        }
    }
}

