/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFront
extends AbstractExecutorService {
    private final Lock lock = new ReentrantLock();
    private final BlockingQueue<Runnable> workQueue;
    private final ExecutorService executor;
    private final String poolName;
    private final long maxTimeSliceMillis;
    private final BlockingQueue<Drainer> drainerList;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceFront.class);

    public ExecutorServiceFront(BlockingQueue<Runnable> workQueue, ExecutorService executor, String poolName, int maxDrainers, long maxTimeSlice, TimeUnit maxTimeSliceUnit) {
        this.workQueue = workQueue;
        this.executor = executor;
        this.poolName = poolName;
        this.maxTimeSliceMillis = maxTimeSliceUnit.toMillis(maxTimeSlice);
        this.drainerList = new ArrayBlockingQueue<Drainer>(maxDrainers);
        for (int i = 0; i < maxDrainers; ++i) {
            this.drainerList.add(new Drainer(String.format("%s-%03d", poolName, i)));
        }
    }

    public ExecutorServiceFront(BlockingQueue<Runnable> workQueue, ExecutorService executor, int maxDrainers, long maxTimeSlice, TimeUnit maxTimeSliceUnit) {
        this(workQueue, executor, "Drainer", maxDrainers, maxTimeSlice, maxTimeSliceUnit);
    }

    public ExecutorServiceFront(BlockingQueue<Runnable> workQueue, ExecutorService executor, String poolName, int maxDrainers) {
        this(workQueue, executor, poolName, maxDrainers, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public ExecutorServiceFront(BlockingQueue<Runnable> workQueue, ExecutorService executor, int maxDrainers) {
        this(workQueue, executor, "Drainer", maxDrainers, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public ExecutorServiceFront(ExecutorService executor, long maxTimeSlice, TimeUnit maxTimeSliceUnit) {
        this(new LinkedBlockingQueue<Runnable>(), executor, "Drainer", 1, maxTimeSlice, maxTimeSliceUnit);
    }

    public ExecutorServiceFront(ExecutorService executor) {
        this(new LinkedBlockingQueue<Runnable>(), executor, 1);
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable task) {
        this.workQueue.offer(task);
        this.lock.lock();
        try {
            if (!this.drainerList.isEmpty()) {
                this.executor.execute((Runnable)this.drainerList.poll());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Drainer
    implements Runnable {
        private final String threadName;

        private Drainer(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public void run() {
            Thread t = Thread.currentThread();
            String oldName = t.getName();
            t.setName(this.threadName);
            try {
                this.internalRun();
            }
            finally {
                t.setName(oldName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalRun() {
            long startTime = DateTimeUtils.currentTimeMillis();
            while (DateTimeUtils.currentTimeMillis() - startTime < ExecutorServiceFront.this.maxTimeSliceMillis) {
                Runnable task = null;
                ExecutorServiceFront.this.lock.lock();
                try {
                    task = (Runnable)ExecutorServiceFront.this.workQueue.poll();
                    if (task == null) {
                        ExecutorServiceFront.this.drainerList.add(this);
                        return;
                    }
                }
                finally {
                    ExecutorServiceFront.this.lock.unlock();
                }
                try {
                    task.run();
                }
                catch (RuntimeException e) {
                    LOG.warn("Ignoring Task Failure", (Throwable)e);
                }
            }
            ExecutorServiceFront.this.lock.lock();
            try {
                if (ExecutorServiceFront.this.workQueue.isEmpty()) {
                    ExecutorServiceFront.this.drainerList.add(this);
                } else {
                    ExecutorServiceFront.this.executor.execute(this);
                }
            }
            finally {
                ExecutorServiceFront.this.lock.unlock();
            }
        }
    }
}

