/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.ExecutorServiceFront;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceFrontBuilder {
    private final ExecutorService coreExecutor;
    private int maxInstanceThreads = 1;
    private long maxTimeSlice = Long.MAX_VALUE;
    private TimeUnit maxTimeSliceUnit = TimeUnit.SECONDS;
    private String drainerBaseName = "Drainer";

    public ExecutorServiceFrontBuilder(ExecutorService coreExecutor) {
        this.coreExecutor = coreExecutor;
    }

    public ExecutorServiceFrontBuilder(ExecutorService coreExecutor, int maxCoreThreads) {
        this.coreExecutor = new ExecutorServiceFront(new LinkedBlockingQueue<Runnable>(), coreExecutor, maxCoreThreads);
    }

    public ExecutorServiceFrontBuilder setMaxInstanceThreads(int maxInstanceThreads) {
        this.maxInstanceThreads = maxInstanceThreads;
        return this;
    }

    public ExecutorServiceFrontBuilder setDrainerBaseName(String name) {
        this.drainerBaseName = name;
        return this;
    }

    public ExecutorServiceFrontBuilder setMaxTimeSlice(long maxTimeSlice, TimeUnit maxTimeSliceUnit) {
        this.maxTimeSlice = maxTimeSlice;
        this.maxTimeSliceUnit = maxTimeSliceUnit;
        return this;
    }

    public ExecutorServiceFront build() {
        return new ExecutorServiceFront(new LinkedBlockingQueue<Runnable>(), this.coreExecutor, this.drainerBaseName, this.maxInstanceThreads, this.maxTimeSlice, this.maxTimeSliceUnit);
    }
}

