/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.collections.TranslatingIterator;
import com.facebook.collectionsbase.Mapper;
import com.facebook.concurrency.CallableSnapshot;
import com.facebook.concurrency.CallableSnapshotFunction;
import com.facebook.concurrency.CastingExceptionHandler;
import com.facebook.concurrency.ConcurrentCache;
import com.facebook.concurrency.CoreConcurrentCache;
import com.facebook.concurrency.EvictionListener;
import com.facebook.concurrency.FixedValueCallable;
import com.facebook.concurrency.NullExceptionHandler;
import com.facebook.concurrency.Reapable;
import com.facebook.concurrency.ValueFactory;
import com.facebook.util.exceptions.ExceptionHandler;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringConcurrentCache<K, V, E extends Exception>
implements ConcurrentCache<K, V, E> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiringConcurrentCache.class);
    private final ConcurrentCache<K, CacheEntry<V, E>, E> baseCache;
    private final long maxAgeMillis;
    private final ExecutorService executor;
    private final AtomicLong lastPrune = new AtomicLong(DateTimeUtils.currentTimeMillis());
    private final AtomicBoolean pruning = new AtomicBoolean(false);
    private final EvictionListener<K, V> evictionListener;

    public ExpiringConcurrentCache(ValueFactory<K, V, E> valueFactory, long maxAge, TimeUnit maxAgeUnit, EvictionListener<K, V> evictionListener, ExceptionHandler<E> exceptionHandler, ExecutorService executor) {
        this.evictionListener = evictionListener;
        this.baseCache = new CoreConcurrentCache<K, CacheEntry<V, E>, E>(new CacheEntryValueFactory(valueFactory), exceptionHandler);
        this.maxAgeMillis = maxAgeUnit.toMillis(maxAge);
        this.executor = executor;
    }

    public ExpiringConcurrentCache(ValueFactory<K, V, E> valueFactory, long maxAge, TimeUnit maxAgeUnit, EvictionListener<K, V> evictionListener, ExceptionHandler<E> exceptionHandler) {
        this(valueFactory, maxAge, maxAgeUnit, evictionListener, exceptionHandler, Executors.newSingleThreadExecutor());
    }

    public static <K, V extends Reapable<? extends Exception>, E extends Exception> ExpiringConcurrentCache<K, V, E> createWithReapableValue(ValueFactory<K, V, E> valueFactory, long maxAge, TimeUnit maxAgeUnit, ExceptionHandler<E> exceptionHandler, ExecutorService executor) {
        return new ExpiringConcurrentCache<Object, Reapable, E>(valueFactory, maxAge, maxAgeUnit, (key, value) -> {
            try {
                value.shutdown();
            }
            catch (Throwable t) {
                LOG.error("error shutting down reapable", t);
            }
        }, exceptionHandler, executor);
    }

    @Override
    public V get(K key) throws E {
        CacheEntry<V, E> cacheEntry = this.baseCache.get(key);
        CallableSnapshot<V, E> snapshot = cacheEntry.touch();
        this.pruneIfNeeded();
        return snapshot.get();
    }

    @Override
    public V put(K key, V value) throws E {
        this.pruneIfNeeded();
        CacheEntry cacheEntry = new CacheEntry(value);
        CacheEntry existingCacheEntry = this.baseCache.put(key, cacheEntry);
        return existingCacheEntry == null ? null : (V)existingCacheEntry.getSnapshot().get();
    }

    @Override
    public V remove(K key) throws E {
        this.pruneIfNeeded();
        CacheEntry<V, E> cacheEntry = this.baseCache.remove(key);
        return cacheEntry == null ? null : (V)cacheEntry.getSnapshot().get();
    }

    @Override
    public boolean removeIfError(K key) {
        return this.baseCache.removeIfError(key);
    }

    @Override
    public void clear() {
        this.baseCache.clear();
    }

    @Override
    public void prune() throws E {
        this.pruneIfNeeded();
    }

    @Override
    public int size() {
        return this.baseCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneIfNeeded() {
        if (DateTimeUtils.currentTimeMillis() - this.lastPrune.get() >= this.maxAgeMillis && this.pruning.compareAndSet(false, true)) {
            try {
                Iterator iterator = this.baseCache.iterator();
                while (iterator.hasNext()) {
                    CacheEntry cacheEntry;
                    Object key;
                    try {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        key = entry.getKey();
                        cacheEntry = (CacheEntry)((CallableSnapshot)entry.getValue()).get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("CacheEntry create should not fail");
                    }
                    if (!cacheEntry.hasExpired(this.maxAgeMillis)) continue;
                    iterator.remove();
                    this.executor.execute(() -> {
                        try {
                            Object value = cacheEntry.getSnapshot().get();
                            try {
                                this.evictionListener.evicted(key, value);
                            }
                            catch (Throwable t) {
                                LOG.error("Error reaping cache element-- may not be properly closed", t);
                            }
                        }
                        catch (Exception e) {
                            LOG.info("Unable to get cache value for key " + key);
                            this.evictionListener.evicted(key, null);
                        }
                    });
                }
            }
            finally {
                this.lastPrune.set(DateTimeUtils.currentTimeMillis());
                this.pruning.set(false);
            }
        }
    }

    @Override
    public Iterator<Map.Entry<K, CallableSnapshot<V, E>>> iterator() {
        return new TranslatingIterator((Mapper)new ValueMapper(), this.baseCache.iterator());
    }

    @Override
    public CallableSnapshot<V, E> getIfPresent(K key) {
        this.pruneIfNeeded();
        CallableSnapshot<CacheEntry<V, E>, E> snapshot = this.baseCache.getIfPresent(key);
        if (snapshot == null) {
            return null;
        }
        try {
            return snapshot.get().getSnapshot();
        }
        catch (Exception e) {
            throw new RuntimeException("this shouldn't happen", e);
        }
    }

    private static class PrivateCallableSnapshot<V, E extends Exception>
    extends CallableSnapshot<V, E> {
        private PrivateCallableSnapshot(Callable<V> callable, ExceptionHandler<E> exceptionHandler) {
            super(callable, exceptionHandler);
        }
    }

    private static class PrivateCallableSnapshotFunction<I, O, E extends Exception>
    implements CallableSnapshotFunction<I, O, E> {
        private final ValueFactory<I, O, E> valueFactory;
        private final ExceptionHandler<E> exceptionHandler;

        private PrivateCallableSnapshotFunction(ValueFactory<I, O, E> valueFactory, ExceptionHandler<E> exceptionHandler) {
            this.valueFactory = valueFactory;
            this.exceptionHandler = exceptionHandler;
        }

        private PrivateCallableSnapshotFunction(ValueFactory<I, O, E> valueFactory) {
            this(valueFactory, new CastingExceptionHandler());
        }

        @Override
        public CallableSnapshot<O, E> apply(I input) {
            return new PrivateCallableSnapshot(() -> this.valueFactory.create(input), this.exceptionHandler);
        }
    }

    private static class CacheEntry<V, E extends Exception> {
        private long mtime = DateTimeUtils.currentTimeMillis();
        private volatile Object snapshotOrValue;

        private CacheEntry(V value) {
            this.snapshotOrValue = value;
        }

        private CacheEntry(CallableSnapshot<V, E> snapshot) {
            if (snapshot.getException() == null) {
                try {
                    this.snapshotOrValue = snapshot.get();
                }
                catch (Exception e) {
                    LOG.error("this should NEVER be seen", (Throwable)e);
                    this.snapshotOrValue = snapshot;
                }
            } else {
                this.snapshotOrValue = snapshot;
            }
        }

        public CallableSnapshot<V, E> getSnapshot() throws E {
            return this.getCallableSnapshot();
        }

        public synchronized CallableSnapshot<V, E> touch() {
            this.mtime = DateTimeUtils.currentTimeMillis();
            return this.getCallableSnapshot();
        }

        public synchronized boolean hasExpired(long maxAgeMillis) {
            return DateTimeUtils.currentTimeMillis() - this.mtime >= maxAgeMillis;
        }

        private CallableSnapshot<V, E> getCallableSnapshot() {
            if (this.snapshotOrValue instanceof PrivateCallableSnapshot) {
                return (CallableSnapshot)this.snapshotOrValue;
            }
            return new PrivateCallableSnapshot(new FixedValueCallable<Object>(this.snapshotOrValue), new NullExceptionHandler());
        }
    }

    private class CacheEntryValueFactory
    implements ValueFactory<K, CacheEntry<V, E>, E> {
        CallableSnapshotFunction<K, V, E> snapshotFunction;

        private CacheEntryValueFactory(ValueFactory<K, V, E> valueFactory) {
            this.snapshotFunction = new PrivateCallableSnapshotFunction(valueFactory);
        }

        @Override
        public CacheEntry<V, E> create(K input) {
            return new CacheEntry(this.snapshotFunction.apply(input));
        }
    }

    private class ValueMapper
    implements Mapper<Map.Entry<K, CallableSnapshot<CacheEntry<V, E>, E>>, Map.Entry<K, CallableSnapshot<V, E>>> {
        private ValueMapper() {
        }

        public Map.Entry<K, CallableSnapshot<V, E>> map(Map.Entry<K, CallableSnapshot<CacheEntry<V, E>, E>> input) {
            CallableSnapshot snapshot;
            try {
                snapshot = input.getValue().get().touch();
            }
            catch (Exception e) {
                throw new RuntimeException("CacheEntry create should not fail");
            }
            return new AbstractMap.SimpleImmutableEntry(input.getKey(), snapshot);
        }
    }
}

