/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.util.exceptions.ExceptionHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class FutureHelper<T, E extends Exception>
extends FutureTask<T> {
    private final AtomicBoolean hasRun = new AtomicBoolean(false);
    private final ExceptionHandler<E> exceptionHandler;
    private volatile boolean generated = false;
    private volatile boolean error = false;

    public FutureHelper(Callable<T> callable, ExceptionHandler<E> exceptionHandler) {
        super(callable);
        this.exceptionHandler = exceptionHandler;
    }

    public T safeGet() throws E {
        if (this.hasRun.compareAndSet(false, true)) {
            this.run();
        }
        try {
            Object t = this.get();
            this.generated = true;
            return (T)t;
        }
        catch (Exception e) {
            this.error = true;
            throw this.exceptionHandler.handle(e);
        }
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isError() {
        return this.error;
    }
}

