/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.NoOp;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class LatchTask
implements Runnable {
    private final CountDownLatch startedLatch = new CountDownLatch(1);
    private final CountDownLatch hasRunLatch = new CountDownLatch(1);
    private final CountDownLatch canRunLatch;
    private final Semaphore canComplete = new Semaphore(1);
    private final Runnable task;

    private LatchTask(boolean canRun, Runnable task) {
        this.canRunLatch = new CountDownLatch(canRun ? 0 : 1);
        this.task = task;
    }

    public LatchTask(Runnable work) {
        this(true, work);
    }

    public LatchTask() {
        this(true, NoOp.INSTANCE);
    }

    public static LatchTask createPaused() {
        return new LatchTask(false, NoOp.INSTANCE);
    }

    public static LatchTask createPaused(Runnable task) {
        return new LatchTask(false, task);
    }

    @Override
    public void run() {
        try {
            this.startedLatch.countDown();
            this.canRunLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.task.run();
        this.hasRunLatch.countDown();
        try {
            this.canComplete.acquire(1);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.canComplete.release(1);
        }
    }

    public synchronized void pauseAfterCompletion() {
        this.canComplete.drainPermits();
    }

    public synchronized LatchTask resumeAfterCompletion() {
        this.canComplete.release(1);
        return this;
    }

    public LatchTask proceed() {
        this.canRunLatch.countDown();
        return this;
    }

    public void waitForStart() throws InterruptedException {
        this.startedLatch.await();
    }

    public boolean hasStarted() {
        return this.startedLatch.getCount() == 0L;
    }

    public void await() throws InterruptedException {
        this.hasRunLatch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.hasRunLatch.await(timeout, unit);
    }
}

