/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.concurrency;

import com.facebook.concurrency.ExecutorServiceFront;
import com.facebook.concurrency.ShortCircuitRunnable;
import com.facebook.concurrency.UnstoppableExecutorService;
import com.facebook.logging.Logger;
import com.facebook.logging.LoggerImpl;
import com.facebook.util.ExtRunnable;
import com.facebook.util.exceptions.ExceptionHandler;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ParallelRunner {
    private static final Logger LOG = LoggerImpl.getLogger(ParallelRunner.class);
    private static final String DEFAULT_NAME_PREFIX = "ParallelRun-";
    private final AtomicLong instanceNumber = new AtomicLong(0L);
    private final ExecutorService executor;
    private final String defaultNamePrefix;

    public ParallelRunner(ExecutorService executor, String defaultNamePrefix) {
        this.executor = executor;
        this.defaultNamePrefix = defaultNamePrefix;
    }

    public ParallelRunner(ExecutorService executor) {
        this(executor, DEFAULT_NAME_PREFIX);
    }

    public <E extends Exception> void parallelRunExt(Iterable<? extends ExtRunnable<E>> tasks, int numThreads, ExceptionHandler<E> exceptionHandler) throws E {
        this.parallelRunExt(tasks.iterator(), numThreads, exceptionHandler);
    }

    public <E extends Exception> void parallelRunExt(Iterator<? extends ExtRunnable<E>> tasksIter, int numThreads, ExceptionHandler<E> exceptionHandler) throws E {
        this.parallelRunExt(tasksIter, numThreads, exceptionHandler, this.defaultNamePrefix + this.instanceNumber.getAndIncrement());
    }

    public <E extends Exception> void parallelRunExt(Iterable<? extends ExtRunnable<E>> tasks, int numThreads, ExceptionHandler<E> exceptionHandler, String baseName) throws E {
        this.parallelRunExt(tasks.iterator(), numThreads, exceptionHandler, baseName);
    }

    public <E extends Exception> void parallelRunExt(Iterator<? extends ExtRunnable<E>> tasksIter, int numThreads, ExceptionHandler<E> exceptionHandler, String baseName) throws E {
        AtomicReference exception = new AtomicReference();
        Iterator wrappedIterator = Iterators.transform(tasksIter, new ShortCircuitRunnable(exception, exceptionHandler));
        this.parallelRun(wrappedIterator, numThreads, baseName);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    public void parallelRun(Iterable<? extends Runnable> tasks, int numThreads) {
        this.parallelRun(tasks.iterator(), numThreads);
    }

    public void parallelRun(Iterator<? extends Runnable> tasksIter, int numThreads) {
        this.parallelRun(tasksIter, numThreads, this.defaultNamePrefix + this.instanceNumber.getAndIncrement());
    }

    public void parallelRun(Iterable<? extends Runnable> tasks, int numThreads, String baseName) {
        this.parallelRun(tasks.iterator(), numThreads, baseName);
    }

    public void parallelRun(Iterator<? extends Runnable> tasksIter, int numThreads, String baseName) {
        UnstoppableExecutorService executorForInvocation = new UnstoppableExecutorService(new ExecutorServiceFront(new LinkedBlockingQueue<Runnable>(), this.executor, baseName, numThreads));
        int totalTasks = 0;
        while (tasksIter.hasNext()) {
            executorForInvocation.execute(tasksIter.next());
            ++totalTasks;
        }
        executorForInvocation.shutdown();
        try {
            while (!executorForInvocation.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.info("(%d) %s waited 10s for %d tasks, waiting some more", new Object[]{Thread.currentThread().getId(), baseName, totalTasks});
            }
            LOG.info("(%d) tasksIter for %s completed", new Object[]{Thread.currentThread().getId(), baseName});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("interrupted waiting for tasks to complete", (Throwable)e);
        }
    }
}

